/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import java.lang.reflect.Method;
import org.ziniki.ziwsh.intf.Dispatcher;
import org.ziniki.ziwsh.intf.DispatchingTraverser;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.Unmarshaller;
import org.ziniki.ziwsh.jvm.CollectingState;
import org.ziniki.ziwsh.jvm.DispatcherTraverser;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;

public class UnmarshallerDispatcher<T>
implements Unmarshaller {
    private final T svc;
    private final Dispatcher dispatcher;

    public UnmarshallerDispatcher(Class<T> clz, T svc, Dispatcher dispatcher) {
        this.svc = svc;
        this.dispatcher = dispatcher;
    }

    public Object service() {
        return this.svc;
    }

    public DispatchingTraverser begin(EvalContext cx, String clz, String method) {
        try {
            Class<?> clzz = Class.forName(clz, false, this.svc.getClass().getClassLoader());
            return this.begin(cx, clzz, method);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public DispatchingTraverser begin(EvalContext cx, Class<?> clz, String method) {
        Method[] methods;
        for (Method m : methods = clz.getDeclaredMethods()) {
            if (!m.getName().equals(method)) continue;
            return this.begin(cx, m);
        }
        throw new NotImplementedException();
    }

    public DispatchingTraverser begin(EvalContext cx, Method method) {
        return new DispatcherTraverser<T>(this.svc, method, cx, new CollectingState(), this.dispatcher);
    }
}

