/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.CollectionState;
import org.ziniki.ziwsh.intf.DispatchingTraverser;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.FieldsMarshaller;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.MarshallingTraverser;
import org.ziniki.ziwsh.intf.NamedIdempotentHandler;
import org.ziniki.ziwsh.intf.ObjectMarshalling;
import org.ziniki.ziwsh.intf.Wireable;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.ArgListMarshaller;
import org.ziniki.ziwsh.jvm.IdempotentHandlerWithName;
import org.ziniki.ziwsh.jvm.UnmarshallerDispatcher;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.reflection.Reflection;

public class ObjectMarshaller
implements ObjectMarshalling {
    private static final Logger logger = LoggerFactory.getLogger((String)"ZiWSH");
    private final MarshallingTraverser top;
    private final boolean includeSecret;

    public ObjectMarshaller(MarshallingTraverser top, boolean includeSecret) {
        this.top = top;
        this.includeSecret = includeSecret;
    }

    public CollectionState state() {
        return this.top.state();
    }

    public void marshal(EvalContext cx, Object o) throws ClassNotFoundException {
        this.marshal(cx, this.top, o);
    }

    public void marshal(EvalContext cx, MarshallingTraverser ux, Object o) throws ClassNotFoundException {
        if (o == null) {
            throw new RuntimeException("I don't EXPECT null to happen");
        }
        if (!ux.handleCycle(o)) {
            if (o instanceof Integer) {
                ux.integer((Integer)o);
            } else if (o instanceof Long) {
                ux.longint((Long)o);
            } else if (o instanceof Boolean) {
                ux.bool((Boolean)o);
            } else if (o instanceof Double) {
                ux.real((Double)o);
            } else if (o instanceof String) {
                ux.string((String)o);
            } else if (o instanceof URI) {
                ux.uri((URI)o);
            } else if (o instanceof Date) {
                ux.date((Date)o);
            } else if (o instanceof NamedIdempotentHandler) {
                NamedIdempotentHandler nih = (NamedIdempotentHandler)o;
                String ihid = cx.getBroker().uniqueHandler(nih.handler());
                nih.bindIhid(ihid);
                cx.bindNamedHandler(nih);
                IdempotentHandlerWithName h = new IdempotentHandlerWithName(ObjectMarshaller.makeHandlerInvoker(cx, nih.handler().getClass(), ihid), null);
                h.bindIhid(ihid);
                ux.handler((IdempotentHandler)h);
            } else if (o instanceof IdempotentHandler) {
                IdempotentHandler ih = (IdempotentHandler)o;
                String ihid = cx.getBroker().uniqueHandler(ih);
                IdempotentHandlerWithName h = new IdempotentHandlerWithName(ObjectMarshaller.makeHandlerInvoker(cx, ih.getClass(), ihid), null);
                h.bindIhid(ihid);
                ux.handler((IdempotentHandler)h);
            } else if (o instanceof Wireable) {
                ux.wireable(cx, (ObjectMarshalling)this, (Wireable)o);
            } else if (o instanceof FieldsContainerWrapper) {
                FieldsContainerWrapper fcw = (FieldsContainerWrapper)o;
                if (!fcw.has("_type")) {
                    throw new RuntimeException("No type defined in " + fcw);
                }
                FieldsMarshaller uf = ux.beginFields(fcw.getClass());
                ux.circle(o, uf.collectingAs());
                fcw.allPlus((x, y) -> {
                    if (!(this.includeSecret || !x.startsWith("_") || x.equals("_id") || x.equals("_type") || x.equals("_version") || x.equals("_clz"))) {
                        return;
                    }
                    uf.field(x);
                    try {
                        this.marshal(cx, (MarshallingTraverser)uf, y);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                });
                uf.complete();
            } else if (o instanceof List || o instanceof Set) {
                MarshallingTraverser ul = ux.beginList();
                ux.circle(o, ul.collectingAs());
                Collection list = (Collection)o;
                for (Object lo : list) {
                    this.marshal(cx, ul, lo);
                }
                ul.complete();
            } else if (o instanceof Map) {
                MarshallingTraverser um = ux.beginMap();
                ux.circle(o, um.collectingAs());
                Map m = (Map)o;
                for (Map.Entry e : m.entrySet()) {
                    um.key((String)e.getKey());
                    this.marshal(cx, um, e.getValue());
                }
                um.complete();
            } else {
                throw new InvalidUsageException("Not handled: " + o.getClass());
            }
        }
    }

    public static IdempotentHandler makeHandlerInvoker(EvalContext cx, Class<? extends IdempotentHandler> cls, String ihid) {
        Class[] intfs;
        ZiwshBroker broker = cx.getBroker();
        if (cls.isInterface()) {
            intfs = new Class[]{cls};
        } else {
            Set tmp = Reflection.allInterfaces(cls);
            intfs = (Class[])tmp.stream().filter(i -> IdempotentHandler.class.isAssignableFrom((Class<?>)i)).toArray(Class[]::new);
        }
        return (IdempotentHandler)Proxy.newProxyInstance(cx.getLoader(), intfs, (InvocationHandler)new BrokerIdemInvoker(broker, cls, ihid));
    }

    public static final class BrokerIdemInvoker
    implements InvocationHandler {
        private final ZiwshBroker broker;
        private final Class<? extends IdempotentHandler> cls;
        private final String ihid;

        private BrokerIdemInvoker(ZiwshBroker broker, Class<? extends IdempotentHandler> cls, String ihid) {
            if (broker == null) {
                throw new CantHappenException("do not pass in a null broker");
            }
            this.broker = broker;
            this.cls = cls;
            this.ihid = ihid;
        }

        public String handler() {
            return this.ihid;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ArgListMarshaller alm;
            if (method.getName().equals("toString")) {
                return "IdemProxy[" + this.ihid + "]";
            }
            if (method.getName().equals("hashCode")) {
                return this.toString().hashCode();
            }
            if (method.getName().equals("equals")) {
                return args[0] == proxy;
            }
            EvalContext uow = this.broker.creator().newContext();
            IdempotentHandler ih = this.broker.currentIdem(this.ihid);
            if (ih == null) {
                logger.warn("attempted to send message to " + this.ihid + " but it was not found");
                return null;
            }
            UnmarshallerDispatcher<IdempotentHandler> um = new UnmarshallerDispatcher<IdempotentHandler>(this.cls, ih, this.broker.getDispatcher());
            DispatchingTraverser ux = um.begin(uow, method.getDeclaringClass(), method.getName());
            if (args.length == 2 && args[1] instanceof Object[]) {
                args = (Object[])args[1];
                alm = new ArgListMarshaller(true, true);
            } else {
                alm = new ArgListMarshaller(false, true);
            }
            alm.marshal(uow, (MarshallingTraverser)ux, args);
            return ux.dispatch();
        }

        public static IdempotentHandler resolveReal(IdempotentHandler h) {
            InvocationHandler ih;
            if (Proxy.isProxyClass(h.getClass()) && (ih = Proxy.getInvocationHandler(h)) instanceof BrokerIdemInvoker) {
                BrokerIdemInvoker bi = (BrokerIdemInvoker)ih;
                return bi.broker.currentIdem(bi.ihid);
            }
            return h;
        }
    }
}

