/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.NoContractFound;

public class NoSuchContract
implements InvocationHandler,
NoContractFound {
    private final String name;

    public NoSuchContract(String name) {
        this.name = name;
    }

    public static <T> T forContract(Class<T> contract) {
        return (T)Proxy.newProxyInstance(contract.getClassLoader(), new Class[]{contract}, (InvocationHandler)new NoSuchContract(contract.getName()));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("toString")) {
            return this.name;
        }
        EvalContext cx = (EvalContext)args[0];
        if (args.length == 2 && args[1] instanceof Object[]) {
            args = (Object[])args[1];
        }
        IdempotentHandler ih = (IdempotentHandler)args[args.length - 1];
        ih.failure(cx, (Object)("there is no service for " + method.getDeclaringClass().getName() + ":" + method.getName()));
        return null;
    }

    public String toString() {
        return "there is no contract bound for " + this.name;
    }
}

