/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.ziniki.ziwsh.intf.DispatchInfo;
import org.ziniki.ziwsh.intf.Dispatcher;
import org.ziniki.ziwsh.intf.DispatchingTraverser;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.ProxyForMarshalling;
import org.ziniki.ziwsh.intf.Unmarshaller;
import org.ziniki.ziwsh.jvm.AreYouA;
import org.zinutils.reflection.Reflection;

public class MarshallerProxy<T>
implements InvocationHandler,
ProxyForMarshalling {
    private final Class<T> contract;
    private final Unmarshaller svc;
    private final Dispatcher dispatcher;

    public MarshallerProxy(Class<T> contract, Unmarshaller svc, Dispatcher dispatcher) {
        this.contract = contract;
        this.svc = svc;
        this.dispatcher = dispatcher;
    }

    public Method method(String name) {
        return Reflection.getFirstMethod(this.contract, (String)name);
    }

    public Object service() {
        return this.svc.service();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("toString")) {
            return "ProxyFor[" + this.svc.getClass().getName() + "]";
        }
        if (method.getName().equals("_areYouA")) {
            return this.contract.getName().equals(args[1]);
        }
        DispatchingTraverser ux = this.svc.begin((EvalContext)args[0], method);
        return this.dispatcher.dispatch((EvalContext)args[0], new DispatchInfo(ux, args));
    }

    public static <T> T proxy(Class<T> contract, Unmarshaller svc, Dispatcher dispatcher) {
        return (T)Proxy.newProxyInstance(contract.getClassLoader(), new Class[]{contract, AreYouA.class}, new MarshallerProxy<T>(contract, svc, dispatcher));
    }
}

