/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.ziniki.ziwsh.intf.CollectionState;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.FieldsMarshaller;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.MarshallingTraverser;
import org.ziniki.ziwsh.intf.NamedIdempotentHandler;
import org.ziniki.ziwsh.intf.ObjectMarshalling;
import org.ziniki.ziwsh.intf.Wireable;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.JsonFieldsMarshaller;
import org.ziniki.ziwsh.jvm.JsonListMarshaller;
import org.ziniki.ziwsh.jvm.JsonMapMarshaller;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;

public abstract class JsonMarshaller
implements MarshallingTraverser {
    protected final JsonGenerator gen;
    private final CollectionState state;
    private final ZiwshBroker broker;

    public JsonMarshaller(JsonGenerator gen, ZiwshBroker broker, CollectionState state) {
        this.broker = broker;
        if (gen == null) {
            throw new NotImplementedException();
        }
        this.gen = gen;
        this.state = state;
    }

    public CollectionState state() {
        return this.state;
    }

    public void key(String key) {
        throw new NotImplementedException("only in map marshaller");
    }

    public boolean handleCycle(Object o) {
        try {
            if (o instanceof List && ((List)o).isEmpty()) {
                return false;
            }
            boolean ret = this.state.has(o);
            if (ret) {
                this.gen.writeStartObject();
                this.gen.writeStringField("_cycle", (String)this.state.get(o));
                this.gen.writeEndObject();
            }
            return ret;
        }
        catch (IOException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public void circle(Object o, Object as) {
        this.state.circle(o, as);
    }

    public void unpack(Object collectingAs) {
        throw new NotImplementedException();
    }

    public void string(String s) {
        try {
            this.gen.writeString(s);
        }
        catch (IOException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public void uri(URI uri) {
        try {
            this.gen.writeStartObject();
            this.gen.writeStringField("_clz", "_uri");
            this.gen.writeStringField("uri", uri.toString());
            this.gen.writeEndObject();
        }
        catch (IOException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public void integer(Integer n) {
        try {
            this.gen.writeNumber(n.intValue());
        }
        catch (IOException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public void longint(Long l) {
        try {
            this.gen.writeNumber(l.longValue());
        }
        catch (IOException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public void bool(Boolean b) {
        try {
            this.gen.writeBoolean(b.booleanValue());
        }
        catch (IOException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public void real(Double d) {
        try {
            this.gen.writeNumber(d.doubleValue());
        }
        catch (IOException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public void date(Date d) {
        try {
            this.gen.writeStartObject();
            this.gen.writeStringField("_clz", "_javaDate");
            this.gen.writeNumberField("mstime", d.getTime());
            this.gen.writeEndObject();
        }
        catch (IOException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public void wireable(EvalContext cx, ObjectMarshalling om, Wireable w) {
        try {
            MarshallingTraverser mt = this.beginMap();
            mt.key("_clz");
            mt.string("_wireable");
            Map fields = w.fields();
            if (!fields.containsKey("_wireable")) {
                mt.key("_wireable");
                mt.string(w.getClass().getName());
            }
            for (Map.Entry e : fields.entrySet()) {
                mt.key((String)e.getKey());
                om.marshal(cx, mt, e.getValue());
            }
            mt.complete();
        }
        catch (IOException | ClassNotFoundException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public FieldsMarshaller beginFields(Class<? extends FieldsContainerWrapper> clz) {
        try {
            this.gen.writeStartObject();
            this.gen.writeStringField("_clz", clz.getName());
            return new JsonFieldsMarshaller(this.gen, this.broker, this.state);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public MarshallingTraverser beginList() {
        try {
            this.gen.writeStartArray();
            return new JsonListMarshaller(this.gen, this.broker, this.state);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public MarshallingTraverser beginMap() {
        try {
            this.gen.writeStartObject();
            return new JsonMapMarshaller(this.gen, this.broker, this.state);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public void handler(IdempotentHandler wrapper) {
        String uniqueName;
        IdempotentHandler handler;
        if (wrapper instanceof NamedIdempotentHandler) {
            NamedIdempotentHandler nih = (NamedIdempotentHandler)wrapper;
            handler = nih.handler();
            uniqueName = nih.ihid();
        } else {
            handler = wrapper;
            uniqueName = this.broker.uniqueHandler(handler);
        }
        Class<? extends IdempotentHandler> clz = this.findHandlerInterface(handler.getClass());
        try {
            this.gen.writeStartObject();
            this.gen.writeStringField("_ihclz", clz.getName());
            this.gen.writeStringField("_ihid", uniqueName);
            this.gen.writeEndObject();
        }
        catch (IOException e) {
            throw WrappedException.wrap((Throwable)e);
        }
    }

    private Class<? extends IdempotentHandler> findHandlerInterface(Class<?> from) {
        Class<?> clz2 = null;
        while (from != null && from != Object.class) {
            Class<?>[] ifs;
            for (Class<?> i : ifs = from.getInterfaces()) {
                if (!IdempotentHandler.class.isAssignableFrom(i) || clz2 != null && clz2 != IdempotentHandler.class) continue;
                clz2 = i;
            }
            from = from.getSuperclass();
        }
        if (clz2 == null) {
            throw new RuntimeException("Failed to find any IdempotentHandler interface");
        }
        return clz2;
    }
}

