/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.CollectionState;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsMarshaller;
import org.ziniki.ziwsh.intf.MarshallingTraverser;
import org.ziniki.ziwsh.intf.ObjectMarshalling;
import org.ziniki.ziwsh.jvm.ObjectMarshaller;
import org.zinutils.exceptions.NotImplementedException;

public class JsonExtractor {
    private static final Logger logger = LoggerFactory.getLogger((String)"ZiWSH");
    private final ClassLoader classLoader;
    private final boolean everything;

    public static Map<String, Object> readObject(JsonParser jp) throws IOException {
        JsonToken tok;
        TreeMap<String, Object> curr = new TreeMap<String, Object>();
        block10: while ((tok = jp.nextToken()) != JsonToken.END_OBJECT) {
            if (tok != JsonToken.FIELD_NAME) {
                throw new RuntimeException("Should have been a field name");
            }
            String afn = jp.getCurrentName();
            tok = jp.nextToken();
            switch (tok) {
                case VALUE_NULL: {
                    curr.put(afn, null);
                    continue block10;
                }
                case VALUE_TRUE: {
                    curr.put(afn, true);
                    continue block10;
                }
                case VALUE_FALSE: {
                    curr.put(afn, false);
                    continue block10;
                }
                case VALUE_STRING: {
                    curr.put(afn, jp.getText());
                    continue block10;
                }
                case VALUE_NUMBER_INT: {
                    curr.put(afn, jp.getLongValue());
                    continue block10;
                }
                case VALUE_NUMBER_FLOAT: {
                    curr.put(afn, Float.valueOf(jp.getFloatValue()));
                    continue block10;
                }
                case START_OBJECT: {
                    Object ret = JsonExtractor.readObject(jp);
                    curr.put(afn, ret);
                    continue block10;
                }
                case START_ARRAY: {
                    Object ret = JsonExtractor.readList(jp);
                    curr.put(afn, ret);
                    continue block10;
                }
            }
            throw new NotImplementedException("can't handle " + tok);
        }
        return curr;
    }

    public static List<Object> readList(JsonParser jp) throws IOException {
        JsonToken tok;
        ArrayList<Object> ret = new ArrayList<Object>();
        block8: while ((tok = jp.nextToken()) != JsonToken.END_ARRAY) {
            switch (tok) {
                case VALUE_TRUE: {
                    ret.add(true);
                    continue block8;
                }
                case VALUE_STRING: {
                    ret.add(jp.getText());
                    continue block8;
                }
                case VALUE_NUMBER_INT: {
                    ret.add(jp.getLongValue());
                    continue block8;
                }
                case VALUE_NUMBER_FLOAT: {
                    ret.add(jp.getDoubleValue());
                    continue block8;
                }
                case START_OBJECT: {
                    Map<String, Object> curr = JsonExtractor.readObject(jp);
                    ret.add(curr);
                    continue block8;
                }
                case START_ARRAY: {
                    List<Object> arr = JsonExtractor.readList(jp);
                    ret.add(arr);
                    continue block8;
                }
            }
            throw new RuntimeException("unhandled arg tok " + tok);
        }
        return ret;
    }

    public JsonExtractor(ClassLoader classLoader, boolean everything) {
        this.classLoader = classLoader;
        this.everything = everything;
    }

    public void unmarshal(EvalContext cx, MarshallingTraverser ux, Object a) throws ClassNotFoundException {
        if (a instanceof Map) {
            this.unmarshalMap(cx, ux, (Map)a);
        } else if (a instanceof List) {
            this.unmarshalList(cx, ux, (List)a);
        } else {
            ObjectMarshaller om = new ObjectMarshaller(ux, false);
            om.marshal(cx, a);
        }
    }

    private void unmarshalMap(EvalContext cx, MarshallingTraverser ux, Map<String, Object> m) throws ClassNotFoundException {
        Class<?> clz;
        if (m.containsKey("_cycle")) {
            ux.handleCycle(m.get("_cycle"));
            return;
        }
        String clzName = (String)m.get("_clz");
        if (clzName == null) {
            MarshallingTraverser um = ux.beginMap();
            for (Map.Entry<String, Object> e : m.entrySet()) {
                um.key(e.getKey());
                this.unmarshal(cx, um, e.getValue());
            }
            um.complete();
            return;
        }
        if (clzName.startsWith("_")) {
            this.handleSpecialClass(cx, ux, clzName, m);
            return;
        }
        try {
            Class<?> foo;
            clz = foo = Class.forName(clzName, false, this.classLoader);
        }
        catch (ClassNotFoundException ex) {
            logger.error("Looking on " + this.classLoader, (Throwable)ex);
            return;
        }
        FieldsMarshaller fm = ux.beginFields(clz);
        ux.unpack(fm.collectingAs());
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (!this.everything && e.getKey().startsWith("_") && !e.getKey().equals("_id") && !e.getKey().equals("_type") && !e.getKey().equals("_version") && !e.getKey().equals("_clz")) continue;
            fm.field(e.getKey());
            Object v = e.getValue();
            if (v instanceof Boolean) {
                fm.bool((Boolean)v);
                continue;
            }
            if (v instanceof String) {
                fm.string((String)v);
                continue;
            }
            if (v instanceof Float) {
                fm.real(Double.valueOf(((Float)v).floatValue()));
                continue;
            }
            if (v instanceof Long) {
                fm.integer(Integer.valueOf((int)((Long)v).longValue()));
                continue;
            }
            if (v instanceof Map) {
                Map m2 = (Map)v;
                this.unmarshalMap(cx, (MarshallingTraverser)fm, m2);
                continue;
            }
            if (v instanceof List) {
                List coll = (List)v;
                this.unmarshalList(cx, (MarshallingTraverser)fm, coll);
                continue;
            }
            throw new NotImplementedException(v.getClass().toString());
        }
        fm.complete();
    }

    private void handleSpecialClass(EvalContext cx, MarshallingTraverser ux, String clzName, Map<String, Object> m) throws ClassNotFoundException {
        switch (clzName) {
            case "_javaDate": {
                long d = (Long)m.get("mstime");
                ux.date(new Date(d));
                return;
            }
            case "_wireable": {
                OMWrapper omw = new OMWrapper(ux);
                ux.wireable(cx, (ObjectMarshalling)omw, cx.fromWire(this.classLoader, (ObjectMarshalling)omw, m));
                return;
            }
        }
        throw new NotImplementedException("There is no special case for " + clzName);
    }

    private void unmarshalList(EvalContext cx, MarshallingTraverser ux, List a) throws ClassNotFoundException {
        MarshallingTraverser lm = ux.beginList();
        ux.unpack(lm.collectingAs());
        for (Object o : a) {
            this.unmarshal(cx, lm, o);
        }
    }

    public class OMWrapper
    implements ObjectMarshalling {
        private final MarshallingTraverser ux;

        public OMWrapper(MarshallingTraverser ux) {
            this.ux = ux;
        }

        public CollectionState state() {
            return this.ux.state();
        }

        public void marshal(EvalContext cx, Object o) throws ClassNotFoundException {
            JsonExtractor.this.unmarshal(cx, this.ux, o);
        }

        public void marshal(EvalContext cx, MarshallingTraverser ux, Object o) throws ClassNotFoundException {
            JsonExtractor.this.unmarshal(cx, ux, o);
        }
    }
}

