/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.Beachhead;
import org.ziniki.ziwsh.intf.DispatchingTraverser;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.EvalContextFactory;
import org.ziniki.ziwsh.intf.HandlerNameProvider;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.JsonSender;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.intf.WebSocketFinder;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.CollectingState;
import org.ziniki.ziwsh.jvm.HandlerCreator;
import org.ziniki.ziwsh.jvm.InvokingState;
import org.ziniki.ziwsh.jvm.JsonExtractor;
import org.ziniki.ziwsh.jvm.JsonMarshallerDispatcher;
import org.ziniki.ziwsh.jvm.ListTraverser;
import org.ziniki.ziwsh.jvm.ZiwshWebClient;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;

public class JsonBeachhead
implements Beachhead {
    private static final Logger logger = LoggerFactory.getLogger((String)"ZiWSH");
    private final EvalContextFactory factory;
    private final String name;
    protected final JsonSender sender;
    protected final ZiwshBroker broker;
    protected final ClassLoader classLoader;
    protected final JsonFactory jf = new JsonFactory();
    private final HandlerCreator creator;
    private final Map<String, String> handlers = new TreeMap<String, String>();

    public JsonBeachhead(WebSocketFinder wsf, EvalContextFactory factory, String name, JsonSender sender, ZiwshBroker broker, HandlerNameProvider nameProvider) {
        this(wsf, factory, name, sender, broker, nameProvider, broker.getClassLoader());
    }

    public JsonBeachhead(WebSocketFinder wsf, EvalContextFactory factory, String name, JsonSender sender, ZiwshBroker broker, HandlerNameProvider nameProvider, ClassLoader loader) {
        if (loader == null) {
            throw new CantHappenException("null loader provided");
        }
        this.factory = factory;
        this.name = name;
        this.sender = sender;
        this.broker = broker;
        this.classLoader = loader;
        this.creator = new HandlerCreator(wsf, broker.getDispatcher(), broker, this.classLoader, nameProvider);
        logger.info("created beachhead " + name + " with sender " + sender);
    }

    public Object service() {
        throw new NotImplementedException();
    }

    public boolean isConnected() {
        if (this.sender instanceof ZiwshWebClient) {
            return ((ZiwshWebClient)this.sender).isOpen();
        }
        return true;
    }

    public void close() {
        if (this.sender instanceof ZiwshWebClient) {
            ((ZiwshWebClient)this.sender).disconnect();
            ((ZiwshWebClient)this.sender).onClose();
        }
    }

    public DispatchingTraverser begin(EvalContext cx, String clz, String method) {
        try {
            StringWriter sw = new StringWriter();
            return new JsonMarshallerDispatcher(this.jf, sw, this.broker, this.sender, clz, method);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public DispatchingTraverser begin(EvalContext cx, Class<?> clz, String method) {
        return this.begin(cx, clz.getName(), method);
    }

    public DispatchingTraverser begin(EvalContext cx, Method method) {
        return this.begin(cx, method.getDeclaringClass().getName(), method.getName());
    }

    public void dispatch(EvalContext uow, String jo, WSResponder replyTo) {
        if (uow == null) {
            uow = this.factory.newContext();
        }
        try {
            logger.info("Dispatching on " + this.name + " with broker " + this.broker.brokerName() + " and will reply to " + replyTo + ":" + jo);
            InvokingState is = new InvokingState(this.broker, this.classLoader, replyTo, this.broker.getDispatcher(), this.creator);
            JsonParser jp = this.jf.createParser(jo);
            if (jp.nextToken() != JsonToken.START_OBJECT) {
                System.out.println("Did not receive an object in " + jo);
                return;
            }
            CollectingState cs = new CollectingState();
            JsonExtractor extractor = new JsonExtractor(uow.getLoader(), false);
            block24: while (jp.nextToken() == JsonToken.FIELD_NAME) {
                String fn = jp.getCurrentName();
                JsonToken tok = jp.nextToken();
                switch (fn) {
                    case "action": {
                        is.action(jp.getText());
                        continue block24;
                    }
                    case "contract": {
                        is.contract(jp.getText());
                        continue block24;
                    }
                    case "method": {
                        is.method(jp.getText());
                        continue block24;
                    }
                    case "args": {
                        block25: while ((tok = jp.nextToken()) != JsonToken.END_ARRAY) {
                            switch (tok) {
                                case VALUE_TRUE: {
                                    is.arg(true);
                                    continue block25;
                                }
                                case VALUE_STRING: {
                                    is.arg(jp.getText());
                                    continue block25;
                                }
                                case VALUE_NUMBER_INT: {
                                    is.arg(jp.getIntValue());
                                    continue block25;
                                }
                                case VALUE_NUMBER_FLOAT: {
                                    is.arg(jp.getDoubleValue());
                                    continue block25;
                                }
                                case START_OBJECT: {
                                    Map<String, Object> curr = JsonExtractor.readObject(jp);
                                    if (curr.containsKey("_ihid")) {
                                        String ihclz = (String)curr.get("_ihclz");
                                        String ihid = (String)curr.get("_ihid");
                                        logger.info(this.name + " remembering handler " + ihid + " of clz " + ihclz);
                                        this.handlers.put(ihid, ihclz);
                                        is.handler(this.jf, ihclz, (JsonSender)replyTo, ihid);
                                        continue block25;
                                    }
                                    ListTraverser trav = new ListTraverser(uow, cs);
                                    extractor.unmarshal(uow, trav, curr);
                                    if (trav.asList().isEmpty()) {
                                        logger.error("unpacked object and found nothing from: " + jo + " given " + curr);
                                        continue block25;
                                    }
                                    Object a0 = trav.asList().get(0);
                                    is.arg(a0);
                                    continue block25;
                                }
                                case START_ARRAY: {
                                    List<Object> arr = JsonExtractor.readList(jp);
                                    ListTraverser trav = new ListTraverser(uow, cs);
                                    extractor.unmarshal(uow, trav, arr);
                                    is.arg(trav.asList().get(0));
                                    continue block25;
                                }
                            }
                            throw new RuntimeException("unhandled arg tok " + tok);
                        }
                        continue block24;
                    }
                    case "idem": {
                        is.idem(jp.getText());
                        continue block24;
                    }
                }
                throw new RuntimeException("who? " + fn);
            }
            is.invoke(uow);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public IdempotentHandler makeHandler(String ihid) throws ClassNotFoundException {
        String ihclz = this.handlers.get(ihid);
        logger.info("creating handler for " + ihid + " of clz " + ihclz);
        return this.creator.createZiwshHandler((WSResponder)this.sender, ihclz, ihid);
    }

    public String toString() {
        return "JsonBeachhead[" + this.name + ":" + this.broker.brokerName() + "]";
    }
}

