/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import com.fasterxml.jackson.core.JsonFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.Dispatcher;
import org.ziniki.ziwsh.intf.DispatchingTraverser;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.JsonSender;
import org.ziniki.ziwsh.intf.MarshallingTraverser;
import org.ziniki.ziwsh.intf.NamedIdempotentHandler;
import org.ziniki.ziwsh.intf.NamedJsonSender;
import org.ziniki.ziwsh.intf.Unmarshaller;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.CollectingState;
import org.ziniki.ziwsh.jvm.HandlerCreator;
import org.ziniki.ziwsh.jvm.IdempotentHandlerWithName;
import org.ziniki.ziwsh.jvm.JsonExtractor;
import org.ziniki.ziwsh.jvm.LoggingIdempotentHandler;
import org.ziniki.ziwsh.jvm.ObjectMarshaller;
import org.ziniki.ziwsh.jvm.RespondingTraverser;
import org.ziniki.ziwsh.jvm.ZiwshWebClient;
import org.zinutils.exceptions.CantHappenException;

public class InvokingState {
    private static final Logger logger = LoggerFactory.getLogger((String)"Broker");
    private final HandlerCreator creator;
    private final ZiwshBroker broker;
    private final ClassLoader classLoader;
    private final WSResponder replyTo;
    private final Dispatcher dispatcher;
    private String action;
    private String contract;
    protected String meth;
    private IdempotentHandler ih;
    private final List<Object> args = new ArrayList<Object>();
    private String idem;

    public InvokingState(ZiwshBroker broker, ClassLoader classLoader, WSResponder replyTo, Dispatcher dispatcher, HandlerCreator creator) {
        this.broker = broker;
        this.classLoader = classLoader;
        if (replyTo == null) {
            throw new CantHappenException("provided null replyTo");
        }
        this.replyTo = replyTo;
        this.dispatcher = dispatcher;
        this.creator = creator;
    }

    public void action(String text) {
        this.action = text;
    }

    public void idem(String text) {
        this.idem = text;
    }

    public void contract(String text) {
        this.contract = text;
    }

    public void method(String text) {
        this.meth = text;
    }

    public void arg(Object a) {
        this.args.add(a);
    }

    public void handler(JsonFactory jf, String ihclz, JsonSender replyTo, String ihid) throws ClassNotFoundException {
        if (replyTo instanceof NamedJsonSender) {
            ihid = ((NamedJsonSender)replyTo).name() + "#" + (String)ihid;
        }
        this.ih = this.getHandler(jf, ihclz, (String)ihid);
    }

    public void invoke(EvalContext cx) throws ClassNotFoundException {
        switch (this.action) {
            case "greetings": {
                this.replyTo.send("{\"action\":\"connected\"}");
                break;
            }
            case "connected": {
                if (!(this.replyTo instanceof ZiwshWebClient)) break;
                ((ZiwshWebClient)this.replyTo).onConnectionAccepted();
                break;
            }
            case "invoke": {
                this.handleInvoke(cx);
                break;
            }
            case "idem": {
                this.handleIdem(cx);
                break;
            }
            default: {
                throw new RuntimeException("Cannot handle " + this.action);
            }
        }
    }

    private void handleInvoke(EvalContext cx) throws ClassNotFoundException {
        Unmarshaller um = this.broker.unmarshalTo(this.contract);
        if (um == null) {
            logger.warn("invoking " + this.contract + ":" + this.meth + ": there is no registered service for " + this.contract);
            IdempotentHandler aih = this.ih;
            if (this.ih instanceof NamedIdempotentHandler) {
                aih = ((NamedIdempotentHandler)this.ih).handler();
            }
            aih.failure(cx, (Object)("there is no service for " + this.contract + ":" + this.meth));
            return;
        }
        DispatchingTraverser dispatcher = um.begin(cx, this.contract, this.meth);
        JsonExtractor ex = new JsonExtractor(this.classLoader, false);
        for (Object a : this.args) {
            ex.unmarshal(cx, (MarshallingTraverser)dispatcher, a);
        }
        if (this.ih instanceof NamedIdempotentHandler) {
            dispatcher.handler(((NamedIdempotentHandler)this.ih).handler());
        } else {
            dispatcher.handler(this.ih);
        }
        dispatcher.dispatch();
    }

    private void handleIdem(EvalContext cx) throws ClassNotFoundException {
        IdempotentHandler ih = this.broker.currentIdem(this.idem);
        RespondingTraverser rt = new RespondingTraverser(ih, this.meth, cx, new CollectingState(), this.dispatcher);
        ObjectMarshaller om = new ObjectMarshaller(rt, false);
        for (Object a : this.args) {
            om.marshal(cx, a);
        }
        if (!"success".equals(this.meth) && !"failure".equals(this.meth)) {
            rt.handler(new LoggingIdempotentHandler());
        }
        rt.dispatch();
    }

    private IdempotentHandler getHandler(JsonFactory jf, String ihclz, String ihid) throws ClassNotFoundException {
        logger.info("Creating ZiWSH handler for " + ihclz);
        return new IdempotentHandlerWithName(this.creator.createZiwshHandler(this.replyTo, ihclz, ihid), null).bindIhid(ihid);
    }
}

