/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.ziniki.ziwsh.intf.Dispatcher;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.JsonSender;
import org.ziniki.ziwsh.intf.MarshallingTraverser;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.CollectingState;
import org.ziniki.ziwsh.jvm.DessicatedHandler;
import org.ziniki.ziwsh.jvm.JacksonStreamer;
import org.ziniki.ziwsh.jvm.JsonListMarshaller;

public class HandlerInvoker
implements InvocationHandler {
    private final Dispatcher dispatcher;
    private final ZiwshBroker broker;
    private final JsonFactory jf;
    private final Class<? extends IdempotentHandler> clz;
    private final String localName;
    private final String remoteName;
    private final WSResponder replyTo;

    public HandlerInvoker(Dispatcher dispatcher, ZiwshBroker broker, JsonFactory jf, Class<? extends IdempotentHandler> clz, String localName, String remoteName, WSResponder replyTo) {
        this.dispatcher = dispatcher;
        this.broker = broker;
        this.jf = jf;
        this.clz = clz;
        this.localName = localName;
        this.remoteName = remoteName;
        this.replyTo = replyTo;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("toString")) {
            return "IH[" + this.localName + "=" + this.clz + ":" + this.remoteName + "]";
        }
        if (method.getName().equals("_handlerID")) {
            return this.localName;
        }
        if (method.getName().equals("_dessication")) {
            DessicatedHandler ret = new DessicatedHandler(this.localName, this.clz.getName(), this.getClass().getName());
            ret.put("_websocket", this.replyTo.dessicated());
            ret.put("_remoteName", this.remoteName);
            return ret;
        }
        if (method.getName().equals("handler")) {
            return proxy;
        }
        this.doReply(this.jf, (JsonSender)this.replyTo, gen -> {
            EvalContext cx = (EvalContext)args[0];
            gen.writeStartObject();
            gen.writeStringField("action", "idem");
            String ihid = this.remoteName;
            if (ihid.indexOf(35) != -1) {
                ihid = ihid.substring(ihid.indexOf(35) + 1);
            }
            gen.writeStringField("idem", ihid);
            gen.writeStringField("method", method.getName());
            gen.writeFieldName("args");
            gen.writeStartArray();
            JsonListMarshaller m = new JsonListMarshaller(gen, this.broker, new CollectingState());
            this.dispatcher.marshalArgs(cx, (MarshallingTraverser)m, args);
            gen.writeEndArray();
            gen.writeEndObject();
        });
        return null;
    }

    private void doReply(JsonFactory jf, JsonSender replyTo, JacksonStreamer streamer) throws Exception {
        StringWriter sw = new StringWriter();
        JsonGenerator jg = jf.createGenerator((Writer)sw);
        streamer.generate(jg);
        jg.close();
        replyTo.send(sw.toString());
    }
}

