/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import com.fasterxml.jackson.core.JsonFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.ziniki.ziwsh.intf.DessicatableHandler;
import org.ziniki.ziwsh.intf.Dessication;
import org.ziniki.ziwsh.intf.Dispatcher;
import org.ziniki.ziwsh.intf.HandlerNameProvider;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.intf.WebSocketFinder;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.HandlerInvoker;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.reflection.Reflection;

public class HandlerCreator {
    private final JsonFactory jf = new JsonFactory();
    private final WebSocketFinder wsf;
    private final Dispatcher dispatcher;
    private final ZiwshBroker broker;
    private final ClassLoader classLoader;
    private final HandlerNameProvider nameProvider;

    public HandlerCreator(WebSocketFinder wsf, Dispatcher dispatcher, ZiwshBroker broker, ClassLoader classLoader, HandlerNameProvider nameProvider) {
        this.wsf = wsf;
        this.dispatcher = dispatcher;
        this.broker = broker;
        this.classLoader = classLoader;
        this.nameProvider = nameProvider;
    }

    public IdempotentHandler hydrate(Dessication dh) throws ClassNotFoundException {
        String impl = dh.impl();
        if (HandlerInvoker.class.getName().equals(impl)) {
            String webSocket = (String)dh.get("_websocket");
            WebSocketFinder.Entry entry = this.wsf.find(webSocket, null);
            if (entry == null) {
                throw new CantHappenException("no entry found for " + webSocket);
            }
            return this.createZiwshHandler(entry.responder(), dh.intf(), (String)dh.get("_remoteName"));
        }
        return this.createLocalHandler(impl, dh);
    }

    public IdempotentHandler createZiwshHandler(WSResponder replyTo, String ihclz, String ihid) throws ClassNotFoundException {
        String localName = this.nameProvider == null ? ihid : this.nameProvider.newName();
        for (ClassLoader cl = this.classLoader; cl != null; cl = cl.getParent()) {
            Class<?> clz = Class.forName(ihclz, false, cl);
            if (clz == null) continue;
            return (IdempotentHandler)Proxy.newProxyInstance(this.classLoader, new Class[]{clz, DessicatableHandler.class}, (InvocationHandler)new HandlerInvoker(this.dispatcher, this.broker, this.jf, clz, localName, ihid, replyTo));
        }
        throw new CantHappenException("there was no handler class " + ihclz);
    }

    private IdempotentHandler createLocalHandler(String impl, Dessication dh) {
        return (IdempotentHandler)Reflection.create((ClassLoader)this.classLoader, (String)impl, (Object[])new Object[]{this, dh});
    }
}

