/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.CollectionState;
import org.ziniki.ziwsh.intf.Dispatcher;
import org.ziniki.ziwsh.intf.DispatchingTraverser;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.NamedIdempotentHandler;
import org.ziniki.ziwsh.jvm.UnmarshalTraverser;
import org.zinutils.exceptions.WrappedException;

public class DispatcherTraverser<T>
extends UnmarshalTraverser
implements DispatchingTraverser {
    private static final Logger logger = LoggerFactory.getLogger((String)"Ziwsh");
    protected final T svc;
    private final Method method;
    private final Dispatcher dispatcher;

    public DispatcherTraverser(T svc, Method method, EvalContext cx, CollectionState state, Dispatcher dispatcher) {
        super(cx, state);
        this.svc = svc;
        this.method = method;
        this.dispatcher = dispatcher;
    }

    public Object dispatch() {
        Object rets;
        block4: {
            rets = null;
            try {
                logger.debug("Invoking " + this.svc.getClass().getName() + "." + this.method.getName() + " on " + this.ret.size() + " args");
                Object[] args = this.ret.toArray();
                EvalContext ec = ((EvalContext)args[0]).bindSubContext(this.svc);
                args[0] = ec;
                if (!ec.isMockContract(this.svc) && args[args.length - 1] instanceof NamedIdempotentHandler) {
                    args[args.length - 1] = ((NamedIdempotentHandler)args[args.length - 1]).handler();
                }
                rets = this.dispatcher.invoke(this.svc, this.method, args);
            }
            catch (Throwable t) {
                t = WrappedException.unwrapThrowable((Throwable)t);
                logger.error("error invoking " + this.svc.getClass().getName() + "." + this.method.getName() + " on " + this.ret.size() + " args", t);
                Object ih = this.ret.get(this.ret.size() - 1);
                if (ih instanceof NamedIdempotentHandler) {
                    ((NamedIdempotentHandler)ih).handler().failure((EvalContext)this.ret.get(0), (Object)t.toString());
                }
                if (!(ih instanceof IdempotentHandler)) break block4;
                ((IdempotentHandler)ih).failure((EvalContext)this.ret.get(0), (Object)t.toString());
            }
        }
        return rets;
    }
}

