/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import java.net.URI;
import java.util.Date;
import org.ziniki.ziwsh.intf.CollectionState;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.FieldsMarshaller;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.MarshallingTraverser;
import org.ziniki.ziwsh.intf.ObjectMarshalling;
import org.ziniki.ziwsh.intf.Wireable;
import org.ziniki.ziwsh.jvm.FieldsTraverser;
import org.ziniki.ziwsh.jvm.ListTraverser;
import org.ziniki.ziwsh.jvm.MapTraverser;
import org.zinutils.exceptions.NotImplementedException;

public abstract class CollectingTraverser
implements MarshallingTraverser {
    protected final EvalContext cx;
    private final CollectionState state;

    public CollectingTraverser(EvalContext cx, CollectionState state) {
        this.cx = cx;
        this.state = state;
    }

    public CollectionState state() {
        return this.state;
    }

    public boolean handleCycle(Object o) {
        boolean ret = this.state.has(o);
        if (ret) {
            this.collect(this.state.get(o));
        }
        return ret;
    }

    public void circle(Object o, Object as) {
        this.state.circle(o, as);
    }

    public Object collectingAs() {
        throw new NotImplementedException();
    }

    public void key(String key) {
        throw new NotImplementedException("only in map marshaller");
    }

    public void unpack(Object collectingAs) {
        this.state.circle(this.state.nextName(), collectingAs);
    }

    public void string(String s) {
        this.collect(s);
    }

    public void uri(URI uri) {
        this.collect(uri);
    }

    public void integer(Integer n) {
        this.collect(n);
    }

    public void longint(Long l) {
        this.collect(l);
    }

    public void bool(Boolean b) {
        this.collect(b);
    }

    public void real(Double d) {
        this.collect(d);
    }

    public void date(Date d) {
        this.collect(d);
    }

    public void wireable(EvalContext cx, ObjectMarshalling om, Wireable w) {
        this.collect(w);
    }

    public FieldsMarshaller beginFields(Class<? extends FieldsContainerWrapper> clz) {
        FieldsTraverser<? extends FieldsContainerWrapper> t = new FieldsTraverser<FieldsContainerWrapper>(this.cx, this.state, clz);
        this.collect(t.creation());
        return t;
    }

    public MarshallingTraverser beginList() {
        ListTraverser lt = new ListTraverser(this.cx, this.state);
        this.collect(lt.asList());
        return lt;
    }

    public MarshallingTraverser beginMap() {
        MapTraverser mt = new MapTraverser(this.cx, this.state);
        this.collect(mt.asMap());
        return mt;
    }

    public void handler(IdempotentHandler handler) {
        this.collect(handler);
    }

    protected abstract void collect(Object var1);
}

