/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.utils.Futures;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.Beachhead;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.jvm.ZiwshWebClient;
import org.zinutils.exceptions.NotImplementedException;

public class ClientSideConnectionHandler
extends WebSocketAdapter
implements CompletionHandler<Connection> {
    private final FutureImpl<Boolean> completeFuture = Futures.createSafeFuture();
    private static final Logger logger = LoggerFactory.getLogger((String)"ZiWSH");
    private final WSResponder replyTo;
    private Beachhead beachhead;

    public ClientSideConnectionHandler(WSResponder replyTo) {
        this.replyTo = replyTo;
    }

    public void attachBeachhead(Beachhead server) {
        this.beachhead = server;
    }

    public void onConnect(WebSocket socket) {
        super.onConnect(socket);
        this.completeFuture.result((Object)Boolean.TRUE);
        logger.debug("connected with socket " + socket);
    }

    public void onMessage(WebSocket socket, String text) {
        super.onMessage(socket, text);
        logger.debug("ziwsh read " + text);
        this.beachhead.dispatch(null, text, this.replyTo);
    }

    public void onClose(WebSocket socket, DataFrame frame) {
        super.onClose(socket, frame);
        logger.info("ziwsh connection closed");
        ((ZiwshWebClient)this.replyTo).onClose();
    }

    public void completed(Connection arg0) {
        logger.debug("connection completed");
    }

    public void cancelled() {
        logger.info("connection cancelled");
        throw new NotImplementedException();
    }

    public void failed(Throwable arg0) {
        logger.info("connection failed", arg0);
        this.completeFuture.failure(arg0);
    }

    public void updated(Connection arg0) {
        logger.info("connection updated");
        throw new NotImplementedException();
    }

    public void await(int cnt, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        logger.debug("awaiting connection for " + cnt + " " + unit);
        this.completeFuture.get((long)cnt, unit);
    }
}

