/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.jvm;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.Beachhead;
import org.ziniki.ziwsh.intf.ConnectTo;
import org.ziniki.ziwsh.intf.Dispatcher;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.JsonSender;
import org.ziniki.ziwsh.intf.ServiceFor;
import org.ziniki.ziwsh.intf.Unmarshaller;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.ArgDispatcher;
import org.ziniki.ziwsh.jvm.JsonBeachhead;
import org.ziniki.ziwsh.jvm.MarshallerProxy;
import org.ziniki.ziwsh.jvm.NoSuchContract;
import org.ziniki.ziwsh.jvm.UnmarshallerDispatcher;
import org.ziniki.ziwsh.jvm.ZiwshWebClient;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.WrappedException;

public abstract class AbstractBroker
implements ZiwshBroker {
    private static final Logger logger = LoggerFactory.getLogger((String)"Broker");
    private final Map<String, Unmarshaller> services = new TreeMap<String, Unmarshaller>();
    private final Map<IdempotentHandler, String> idems = new HashMap<IdempotentHandler, String>();
    private final Map<String, IdempotentHandler> idemLookup = new TreeMap<String, IdempotentHandler>();
    private Map<String, ServiceFor> serviceHandlers = new HashMap<String, ServiceFor>();
    private Unmarshaller server;
    private int nextHandler = 1;
    private Dispatcher dispatcher;
    private static int brokerId = 1;
    private final String brokerName = "broker_" + brokerId++;
    private final Map<String, Beachhead> clients = new TreeMap<String, Beachhead>();

    public AbstractBroker() {
        this(new ArgDispatcher());
    }

    public AbstractBroker(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        logger.info("creating broker " + this.brokerName);
    }

    public void close() {
        for (Beachhead cli : this.clients.values()) {
            cli.close();
        }
    }

    public String brokerName() {
        return this.brokerName;
    }

    public JsonSender connectBeachhead(ConnectTo peer, SSLEngineConfigurator config) {
        logger.info("attempting to connect beachhead to " + peer + " from " + this.brokerName);
        if (peer.getURI() == null) {
            throw new RuntimeException("no ws uri provided");
        }
        if (peer.getURI().getScheme() == null) {
            throw new RuntimeException("invalid ws uri: " + peer);
        }
        if (peer.getURI().getScheme().equals("wss") && config == null) {
            throw new RuntimeException("Cannot specify wss without providing a configuration context");
        }
        if (peer.getURI().getScheme().equals("ws") && config != null) {
            throw new RuntimeException("Cannot provide a configuration context for ws://");
        }
        ZiwshWebClient zwc = new ZiwshWebClient(this, peer, config);
        Beachhead bh = this.makeBeachhead((JsonSender)zwc, peer.toString());
        this.server = bh;
        zwc.attachBeachhead(bh);
        zwc.connectionProtocol();
        return zwc;
    }

    public Beachhead connectBeachhead(String name, JsonSender sender) {
        logger.info("attempting to connect beachhead to " + name + " from " + this.brokerName + " using " + sender);
        Beachhead bh = this.makeBeachhead(sender, name);
        this.server = bh;
        return bh;
    }

    public void clientBeachhead(String name, Beachhead bh) {
        logger.info("attempting to connect client beachhead to " + name + " from " + this.brokerName + ": " + bh);
        this.clients.put(name, bh);
    }

    public boolean successfullyConnected() {
        return this.server != null && this.server instanceof Beachhead && ((Beachhead)this.server).isConnected();
    }

    protected abstract Beachhead makeBeachhead(JsonSender var1, String var2);

    public boolean hasBeachhead() {
        return this.server != null;
    }

    public void dropBeachhead() {
        if (this.server instanceof ZiwshWebClient) {
            ((ZiwshWebClient)this.server).disconnect();
        }
        this.server = null;
    }

    public void beachhead(Beachhead server) {
        logger.info("attaching beachhead " + server + " to " + this.brokerName);
        this.server = server;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public <T> void register(Class<T> clz, T svc) {
        logger.info("registering service " + clz.getName() + " on " + this.brokerName);
        this.services.put(clz.getName(), new UnmarshallerDispatcher<T>(clz, svc, this.dispatcher));
    }

    public <T> void registerUnmarshaller(Class<T> clz, Unmarshaller svc) {
        logger.info("registering unmarshaller for service " + clz.getName() + " on " + this.brokerName);
        this.services.put(clz.getName(), svc);
    }

    public <T> T require(Class<T> contract) {
        Unmarshaller svc = this.services.get(contract.getName());
        if (svc == null) {
            logger.info("requiring contract for " + contract.getName() + " from " + this.brokerName + " with server = " + this.server);
            if (this.server != null) {
                svc = this.server;
            } else {
                logger.warn("there is no contract for " + contract.getName());
                return NoSuchContract.forContract(contract);
            }
        }
        return MarshallerProxy.proxy(contract, svc, this.dispatcher);
    }

    public <T> T requireFromServer(Class<T> contract) {
        logger.info("requiring contract for " + contract.getName() + " from server in " + this.brokerName);
        if (this.server != null) {
            return MarshallerProxy.proxy(contract, this.server, this.dispatcher);
        }
        logger.warn("there is no contract for " + contract.getName());
        return NoSuchContract.forContract(contract);
    }

    public Unmarshaller unmarshalTo(String contract) {
        return this.services.get(contract);
    }

    public String uniqueHandler(IdempotentHandler handler) {
        String name = "handler_" + this.nextHandler++;
        this.idems.put(handler, name);
        this.idemLookup.put(name, handler);
        logger.info("remembering handler " + handler + " as " + name + " in " + this.brokerName);
        return name;
    }

    public IdempotentHandler currentIdem(String handle) {
        int hash = handle.indexOf(35);
        if (hash != -1) {
            try {
                String remote = handle.substring(0, hash);
                JsonBeachhead bh = (JsonBeachhead)this.clients.get(remote);
                if (bh == null) {
                    throw new CantHappenException(this.brokerName + ": there is no remote for " + remote);
                }
                return bh.makeHandler(handle.substring(hash + 1));
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Throwable)ex);
            }
        }
        IdempotentHandler ret = this.idemLookup.get(handle);
        logger.info("recovered handler " + ret + " from " + handle + " in " + this.brokerName);
        if (ret == null) {
            throw new CantHappenException("Cannot find idem for " + handle);
        }
        return ret;
    }

    public void serviceFor(String ihid, ServiceFor service) {
        this.serviceHandlers.put(ihid, service);
    }

    public void cancel(EvalContext cx, String old) {
        IdempotentHandler h = this.idemLookup.get(old);
        if (h == null) {
            logger.warn("cancelling " + old + " when it is not present");
            return;
        }
        this.idemLookup.remove(old);
        this.idems.remove(h);
        ServiceFor sf = this.serviceHandlers.remove(old);
        if (sf != null) {
            sf.cancel(cx);
        }
    }
}

