/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.stdlib.mock;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.flasck.flas.testrunner.JSJavaBridge;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.container.BoundVar;
import org.flasck.jvm.container.UpdatesDisplay;
import org.flasck.jvm.fl.EventZone;
import org.flasck.jvm.fl.MockAjax;
import org.flasck.jvm.fl.NotMatched;
import org.flasck.jvm.fl.TestHelper;
import org.flasck.stdlib.mock.MockAppl;
import org.flasck.stdlib.mock.StdlibMock;
import org.jsoup.select.Elements;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.reflection.Reflection;

public class StdlibMockImpl
implements StdlibMock {
    private final TestHelper helper;
    private final List<MockAjax> ajaxen = new ArrayList<MockAjax>();
    private final List<MockAppl> appls = new ArrayList<MockAppl>();

    public static StdlibMockImpl createJVM(TestHelper helper, File rootdir) {
        return new StdlibMockImpl(helper);
    }

    public static StdlibMockImpl createChrome(JSJavaBridge bridge, ClassLoader classLoader, File root) {
        return null;
    }

    public StdlibMockImpl(TestHelper helper) {
        this.helper = helper;
    }

    @Override
    public MockAjax newAjax(FLEvalContext cxt, URI uri) {
        MockAjax ret = (MockAjax)Reflection.create((ClassLoader)this.helper.loader(), (String)"org.flasck.stdlib.mock.MockingAjax", (Object[])new Object[]{cxt, uri});
        this.ajaxen.add(ret);
        return ret;
    }

    @Override
    public MockAppl newMockAppl(FLEvalContext cxt, Class<?> applClz) {
        MockAppl ret = (MockAppl)Reflection.create((ClassLoader)this.helper.loader(), (String)"org.flasck.stdlib.mock.MockingApplication", (Object[])new Object[]{cxt, applClz});
        this.appls.add(ret);
        return ret;
    }

    @Override
    public void matchTitle(FLEvalContext cx, Object card, List<EventZone> zone, boolean contains, String matches) throws NotMatched {
        UpdatesDisplay mc = (UpdatesDisplay)card;
        if (this.helper.hasMock((Object)mc)) {
            mc = (UpdatesDisplay)this.helper.mock((Object)mc);
        }
        if (!(mc instanceof MockAppl)) {
            throw new RuntimeException("Can only test title of MockAppl");
        }
        Elements titles = this.helper.document().head().getElementsByTag("title");
        String content = titles.text().trim().replace('\n', ' ').replaceAll(" +", " ");
        if (contains ? !content.contains(matches) : !content.equals(matches)) {
            throw new NotMatched(zone, matches, content);
        }
    }

    @Override
    public void route(FLEvalContext cx, Object app, Object route, Object storeCards) {
        MockAppl appl = (MockAppl)app;
        appl.route(cx, (String)route);
        try {
            cx.waitForQueueDone();
        }
        catch (TimeoutException ex) {
            throw new HaventConsideredThisException("timed out");
        }
        if (storeCards != null) {
            appl.bindCards(cx, (BoundVar)storeCards);
        }
    }

    @Override
    public void userlogin(FLEvalContext cx, Object app, Object user) {
        MockAppl appl = (MockAppl)app;
        appl.userlogin(cx, (String)user);
    }
}

