/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.stdlib.mock;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.AjaxMessage;
import org.flasck.jvm.builtin.FLError;
import org.flasck.jvm.builtin.PACKAGEFUNCTIONS.parseJson;
import org.flasck.jvm.fl.AjaxExpector;
import org.flasck.stdlib.mock.MockActiveSubscriber;

public class MockAjaxSubscriber
implements AjaxExpector {
    private Object path;
    private final List<Object> responses = new ArrayList<Object>();
    private int nextResponse = 0;

    public MockAjaxSubscriber(FLEvalContext cx, Object path) {
        this.path = path;
    }

    public void response(FLEvalContext cx, Object o) {
        this.responses.add(o);
    }

    public void dispatch(FLEvalContext cx, URI baseUri, List<Object> activeSubscribers) {
        if (this.nextResponse > this.responses.size()) {
            return;
        }
        for (Object s : activeSubscribers) {
            if (!this.matchAndSend(cx, baseUri, s)) continue;
            return;
        }
    }

    private boolean matchAndSend(FLEvalContext cx, URI baseUri, Object s) {
        MockActiveSubscriber sub = (MockActiveSubscriber)s;
        if (sub.uriString().equals(baseUri.resolve((String)this.path).toString())) {
            AjaxMessage msg;
            Object resp = this.responses.get(this.nextResponse++);
            if ((resp = cx.full(resp)) instanceof FLError) {
                cx.log(resp);
                return true;
            }
            if (resp instanceof AjaxMessage) {
                msg = (AjaxMessage)resp;
            } else {
                msg = new AjaxMessage(cx);
                msg.set("headers", new ArrayList());
                msg.set("body", parseJson.objectToJsonString((FLEvalContext)cx, (Object)resp));
            }
            sub.dispatch(cx, msg);
            try {
                cx.waitForQueueDone();
            }
            catch (TimeoutException ex) {
                cx.log((Object)ex.getMessage());
            }
            return true;
        }
        return false;
    }
}

