/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.servlet.tda.ResponseReadyContinuation;

public class InputStreamResponder
implements ResponseReadyContinuation {
    final char[] cbuf = new char[10000];
    final byte[] bbuf = new byte[10000];
    private Responder responder;
    private Reader reader;
    private InputStream stream;

    public void sendBinary(Responder r, InputStream stream, String contentType, long contentLength) throws IOException {
        this.responder = r;
        this.stream = stream;
        r.setStatus(200);
        if (contentType != null) {
            r.setContentType(contentType);
        }
        if (contentLength > 0L) {
            r.setContentLength(contentLength);
        }
        this.responseReady();
    }

    public void sendText(Responder r, Reader reader, String contentType, long contentLength) throws IOException {
        this.responder = r;
        this.reader = reader;
        r.setStatus(200);
        if (contentType != null) {
            r.setContentType(contentType);
        }
        if (contentLength > 0L) {
            r.setContentLength(contentLength);
        }
        this.responseReady();
    }

    public boolean responseReady() throws IOException {
        boolean bp = true;
        try {
            if (this.reader != null) {
                int rc;
                while (bp && (rc = this.reader.read(this.cbuf)) >= 0) {
                    bp = this.responder.write(this.cbuf, 0, rc, (ResponseReadyContinuation)this);
                }
            } else {
                int rc;
                while (bp && (rc = this.stream.read(this.bbuf, 0, this.bbuf.length)) >= 0) {
                    bp = this.responder.write(this.bbuf, 0, rc, (ResponseReadyContinuation)this);
                }
            }
        }
        catch (NotReadyException ex) {
            ex.printStackTrace();
        }
        if (bp) {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.stream != null) {
                this.stream.close();
            }
        }
        return bp;
    }

    public void streamError(Throwable err) {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.responder.handleError(err);
    }
}

