/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.tda.writers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.servlet.tda.ResponseReadyContinuation;

public class ContinuationWriter
implements ResponseReadyContinuation {
    private final Responder resp;
    private final List<String> pending = new ArrayList<String>();
    private boolean ready = true;
    private boolean done;

    public ContinuationWriter(Responder resp) {
        this.resp = resp;
    }

    public synchronized void write(String s) throws IOException, NotReadyException {
        if (!this.ready) {
            this.pending.add(s);
        } else {
            this.ready = this.resp.write(s, (ResponseReadyContinuation)this);
        }
    }

    public synchronized void done() {
        this.done = true;
        if (this.ready) {
            this.resp.done();
        }
    }

    public synchronized boolean responseReady() throws IOException, NotReadyException {
        while (this.pending.size() > 0) {
            String s = this.pending.remove(0);
            if (this.resp.write(s, (ResponseReadyContinuation)this)) continue;
            return false;
        }
        this.ready = true;
        if (this.done) {
            this.resp.done();
        }
        return true;
    }

    public void streamError(Throwable err) {
        this.resp.done();
    }
}

