/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.tda.writers;

import java.io.IOException;
import java.io.Writer;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.servlet.tda.ResponseReadyContinuation;

public class BackwardsCompatibleBlockingWriter
extends Writer
implements ResponseReadyContinuation {
    private final Responder r;
    private final Object blocker = new Object();
    private Throwable exc;

    public BackwardsCompatibleBlockingWriter(Responder r) {
        this.r = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.blocker;
        synchronized (object) {
            try {
                if (!this.r.write(cbuf, off, len, (ResponseReadyContinuation)this)) {
                    this.blocker.wait();
                }
                if (this.exc != null) {
                    throw new IOException(this.exc);
                }
            }
            catch (InterruptedException | NotReadyException ex) {
                throw new IOException(ex);
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean responseReady() throws IOException, NotReadyException {
        Object object = this.blocker;
        synchronized (object) {
            this.blocker.notifyAll();
        }
        return true;
    }

    public void streamError(Throwable err) {
        this.exc = err;
    }
}

