/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.tda.readers;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.tda.BytesPresenter;

public class PathReader
implements CompletionHandler<Integer, Object> {
    protected final Logger logger = LoggerFactory.getLogger((String)"PathReader");
    private final AsynchronousFileChannel channel;
    private final BytesPresenter handler;
    private final ByteBuffer b = ByteBuffer.allocate(5);
    private int pos = 0;

    public PathReader(Path from, BytesPresenter h) throws IOException {
        this.handler = h;
        this.channel = AsynchronousFileChannel.open(from, new OpenOption[0]);
    }

    public static void send(Path from, BytesPresenter h) throws Exception {
        new PathReader(from, h).doread(0);
    }

    private void doread(int k) {
        this.pos += k;
        this.channel.read(this.b, this.pos, null, this);
    }

    @Override
    public void completed(Integer k, Object attachment) {
        try {
            if (k == -1) {
                this.handler.present(null);
            } else if (k == 0) {
                this.logger.debug("blocked ... need to select()");
            } else {
                byte[] bs = new byte[k.intValue()];
                this.b.flip();
                this.b.get(bs);
                this.handler.present(bs);
                this.b.clear();
                this.doread(k);
            }
        }
        catch (Throwable ex) {
            this.failed(ex, (Object)null);
        }
    }

    @Override
    public void failed(Throwable ex, Object attachment) {
        ex.printStackTrace();
    }
}

