/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.tda.readers;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.ziniki.server.tda.BytesPresenter;

public class HttpReader {
    public static void send(String url, BytesPresenter h) throws Exception {
        AsyncHttpClient cli = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(new AsyncHttpClientConfig.Builder().setHostnameVerifier(HttpReader.createHostnameVerifier()).setSSLContext(HttpReader.createSslContext()).build()));
        cli.prepareGet(url).execute((AsyncHandler)new ForwardResponseToTDA(h, cli));
    }

    public static void send(String url, FluentCaseInsensitiveStringsMap headers, String body, BytesPresenter h) throws Exception {
        AsyncHttpClient cli = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(new AsyncHttpClientConfig.Builder().setHostnameVerifier(HttpReader.createHostnameVerifier()).setSSLContext(HttpReader.createSslContext()).build()));
        cli.preparePost(url).setHeaders(headers).setBody(body.getBytes()).execute((AsyncHandler)new ForwardResponseToTDA(h, cli));
    }

    private static SSLContext createSslContext() throws Exception {
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                System.out.println("checking client " + string);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                System.out.println("checking server " + string);
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                System.out.println("returning accepted issuers");
                return null;
            }
        };
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, new TrustManager[]{tm}, null);
        return ctx;
    }

    private static HostnameVerifier createHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                System.out.println("verifying " + hostname);
                return true;
            }
        };
    }

    public static final class ForwardResponseToTDA
    implements AsyncHandler<Void> {
        private final BytesPresenter h;
        private final AsyncHttpClient cli;

        public ForwardResponseToTDA(BytesPresenter h, AsyncHttpClient cli) {
            this.h = h;
            this.cli = cli;
        }

        public AsyncHandler.STATE onStatusReceived(HttpResponseStatus arg0) throws Exception {
            if (arg0.getStatusCode() != 200) {
                this.h.present(null);
                this.cli.close();
                return AsyncHandler.STATE.ABORT;
            }
            return AsyncHandler.STATE.CONTINUE;
        }

        public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders arg0) throws Exception {
            return AsyncHandler.STATE.CONTINUE;
        }

        public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart arg0) throws Exception {
            this.h.present(arg0.getBodyPartBytes());
            return AsyncHandler.STATE.CONTINUE;
        }

        public Void onCompleted() throws Exception {
            this.h.present(null);
            this.cli.close();
            return null;
        }

        public void onThrowable(Throwable arg0) {
            arg0.printStackTrace();
        }
    }
}

