/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.path;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.di.DehydratedHandler;
import org.ziniki.server.di.MakeAHandler;
import org.ziniki.server.path.NoHandlerException;
import org.ziniki.server.path.PathConflictException;
import org.ziniki.server.path.PathResolutionException;
import org.ziniki.server.path.PathTree;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestPathParameters;
import org.ziniki.servlet.tda.TDAConfiguration;

public class SimplePathTree<T>
implements PathTree<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)"tdaserver");
    private MakeAHandler<T> terminatesHereHandler = null;
    private Map<String, Object> handlers = new HashMap<String, Object>();
    private String defVar;
    private PathTree<T> defTree;
    private MakeAHandler<T> everythingElseHandler;

    @Override
    public boolean isEmpty() {
        return this.handlers.isEmpty() && this.defTree == null && this.everythingElseHandler == null;
    }

    @Override
    public void add(String path, MakeAHandler<T> handler) {
        if (path == null) {
            if (this.terminatesHereHandler != null) {
                throw new RuntimeException("Duplicate path");
            }
            this.terminatesHereHandler = handler;
            return;
        }
        String rem = null;
        Object store = handler;
        int idx = path.indexOf(47, 1);
        if (idx != -1) {
            rem = path.substring(idx);
            path = path.substring(0, idx);
        }
        if (path.startsWith("/*")) {
            if (rem != null) {
                throw new PathConflictException("Cannot specify " + rem + " after /*");
            }
            if (this.defVar != null || this.defTree != null) {
                throw new PathConflictException("Cannot specify /{} and /* for path");
            }
            if (this.everythingElseHandler != null) {
                throw new PathConflictException("Cannot specify /* multiple times for same base path");
            }
            this.everythingElseHandler = handler;
        } else if (path.startsWith("/{")) {
            if (this.everythingElseHandler != null) {
                throw new PathConflictException("Cannot specify /{} and /* for same base path");
            }
            this.defVar = path.substring(2, path.length() - 1);
            if (this.defTree == null) {
                this.defTree = new SimplePathTree<T>();
            }
            this.defTree.add(rem, handler);
        } else {
            store = this.handlers.get(path);
            if (rem != null) {
                PathTree<T> sub;
                if (store == null) {
                    sub = new SimplePathTree<T>();
                    this.handlers.put(path, sub);
                } else if (store instanceof PathTree) {
                    PathTree tmp = (PathTree)store;
                    sub = tmp;
                } else {
                    DehydratedHandler h = (DehydratedHandler)store;
                    sub = new SimplePathTree<T>();
                    sub.add(null, h);
                    this.handlers.put(path, sub);
                }
                sub.add(rem, handler);
            } else if (store == null) {
                this.handlers.put(path, handler);
            } else if (store instanceof PathTree) {
                PathTree sub = (PathTree)store;
                sub.add(null, handler);
            } else {
                throw new PathConflictException("Cannot specify the exact path " + path + " multiple times");
            }
        }
    }

    @Override
    public T makeHandler(TDAConfiguration config, String path) throws Exception {
        if (path == null) {
            if (this.terminatesHereHandler == null) {
                throw new PathResolutionException("There is no handler for the terminated path");
            }
            return this.terminatesHereHandler.instantiate(config);
        }
        String rem = null;
        int idx = path.indexOf(47, 1);
        if (idx != -1) {
            rem = path.substring(idx);
            path = path.substring(0, idx);
        }
        if (this.handlers.containsKey(path)) {
            Object obj = this.handlers.get(path);
            if (obj instanceof MakeAHandler) {
                if (rem != null) {
                    throw new PathResolutionException("cannot handle " + rem + " after " + path);
                }
                MakeAHandler dh = (MakeAHandler)obj;
                return dh.instantiate(config);
            }
            PathTree pt = (PathTree)obj;
            return pt.makeHandler(config, rem);
        }
        if (this.defTree != null) {
            return this.defTree.makeHandler(config, rem);
        }
        if (this.everythingElseHandler != null) {
            return this.everythingElseHandler.instantiate(config);
        }
        throw new PathResolutionException("There is no handler for " + path);
    }

    @Override
    public T makeUniqueHandler(TDAConfiguration config) throws Exception {
        if (this.terminatesHereHandler != null) {
            if (!this.handlers.isEmpty()) {
                throw new NoHandlerException("terminatesHere = " + this.terminatesHereHandler + " and we have " + this.handlers.size() + " handlers");
            }
            return this.terminatesHereHandler.instantiate(config);
        }
        if (this.handlers.size() == 1) {
            Object obj = this.handlers.values().iterator().next();
            if (obj instanceof DehydratedHandler) {
                DehydratedHandler dh = (DehydratedHandler)obj;
                return dh.instantiate(config);
            }
            PathTree pt = (PathTree)obj;
            return pt.makeUniqueHandler(config);
        }
        if (this.handlers.isEmpty() && this.defTree != null) {
            return this.defTree.makeUniqueHandler(config);
        }
        throw new NoHandlerException("no handler could be found");
    }

    @Override
    public void populate(RequestPathParameters instance, String path) {
        if (path == null) {
            return;
        }
        String rem = null;
        int idx = path.indexOf(47, 1);
        if (idx != -1) {
            rem = path.substring(idx);
            path = path.substring(0, idx);
        }
        if (!this.handlers.containsKey(path) && this.defVar != null) {
            logger.debug("offering " + path.substring(1) + " for var " + this.defVar);
            instance.stringValue(this.defVar, path.substring(1), ParameterSource.PATH);
        } else if (!this.handlers.containsKey(path) && this.everythingElseHandler != null) {
            instance.stringValue("*", path, ParameterSource.PATH);
        }
        if (rem != null) {
            Object rec = this.handlers.get(path);
            if (rec instanceof PathTree) {
                PathTree nested = (PathTree)rec;
                nested.populate(instance, rem);
            } else if (this.defTree != null) {
                this.defTree.populate(instance, rem);
            } else if (this.everythingElseHandler != null) {
                instance.stringValue("*", path + rem, ParameterSource.PATH);
            }
        }
    }

    public String toString() {
        return "SPT[" + this.handlers + "]";
    }
}

