/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.grizzly;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.CentralServerStore;
import org.ziniki.server.NewConnectionHandler;
import org.ziniki.server.grizzly.GrizzlyTDATransport;
import org.ziniki.server.path.PathTree;
import org.ziniki.server.tda.ProvideHostInfo;
import org.ziniki.server.tda.WSReceiver;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.ProvideHeaders;
import org.ziniki.servlet.tda.RequestPathParameters;
import org.ziniki.servlet.tda.RequestQueryAndPostParameters;
import org.ziniki.ziwsh.intf.WSProcessor;

public class GrizzlyTDAWebSocketHandler
extends WebSocketApplication
implements CentralServerStore {
    private static final Logger logger = LoggerFactory.getLogger((String)"tdaserver");
    private final List<TreeHandler> handlers = new ArrayList<TreeHandler>();

    public GrizzlyTDAWebSocketHandler() {
        WebSocketEngine.getEngine().register("", "/*", (WebSocketApplication)this);
    }

    @Override
    public void addWSHandler(PathTree<WSProcessor> tree, NewConnectionHandler<? extends WSReceiver> handler) {
        this.handlers.add(new TreeHandler(tree, handler));
    }

    public void onConnect(WebSocket socket) {
        if (!(socket instanceof DefaultWebSocket)) {
            throw new RuntimeException("Need a DefaultWebSocket");
        }
        DefaultWebSocket ws = (DefaultWebSocket)socket;
        WSReceiver instance = null;
        String host = ws.getUpgradeRequest().getServerName();
        int port = ws.getUpgradeRequest().getServerPort();
        String path = ws.getUpgradeRequest().getPathInfo();
        try {
            Iterator<TreeHandler> trees = this.handlers.iterator();
            TreeHandler next = null;
            while (instance == null && trees.hasNext()) {
                next = trees.next();
                instance = (WSReceiver)next.tree.makeHandler(null, path);
            }
            if (instance == null) {
                logger.error("Could not make handler for " + path);
                ws.close();
                return;
            }
            if (instance instanceof ProvideHostInfo) {
                ((ProvideHostInfo)((Object)instance)).provideHost(host, port);
            }
            if (instance instanceof ProvideHeaders) {
                ProvideHeaders ph = (ProvideHeaders)instance;
                Enumeration en = ws.getUpgradeRequest().getHeaderNames();
                while (en.hasMoreElements()) {
                    String h = (String)en.nextElement();
                    Enumeration headers = ws.getUpgradeRequest().getHeaders(h);
                    while (headers.hasMoreElements()) {
                        ph.header(h, (String)headers.nextElement());
                    }
                }
            }
            if (instance instanceof RequestPathParameters) {
                next.tree.populate((RequestPathParameters)instance, path);
            }
            if (instance instanceof RequestQueryAndPostParameters) {
                RequestQueryAndPostParameters qpp = (RequestQueryAndPostParameters)instance;
                Map parameters = ws.getUpgradeRequest().getParameterMap();
                for (Map.Entry pe : parameters.entrySet()) {
                    for (String v : (String[])pe.getValue()) {
                        logger.debug("offering parameter " + v + " for " + (String)pe.getKey());
                        qpp.stringValue((String)pe.getKey(), v, ParameterSource.QUERYPOST);
                    }
                }
            }
            GrizzlyTDATransport t = new GrizzlyTDATransport((WebSocket)ws);
            next.handler.newConnection(t, instance);
        }
        catch (Exception e) {
            logger.error("Could not make handler for websocket " + path, (Throwable)e);
        }
    }

    protected boolean onError(WebSocket socket, Throwable t) {
        logger.info("error on " + socket, t);
        return false;
    }

    public class TreeHandler {
        private final PathTree<WSProcessor> tree;
        private final NewConnectionHandler<WSReceiver> handler;

        public TreeHandler(PathTree<WSProcessor> tree, NewConnectionHandler<WSReceiver> handler) {
            this.tree = tree;
            this.handler = handler;
        }
    }
}

