/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.grizzly;

import java.io.IOException;
import java.net.BindException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpHandlerRegistration;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.CentralServerStore;
import org.ziniki.server.NewConnectionHandler;
import org.ziniki.server.TDAServer;
import org.ziniki.server.grizzly.GrizzlyTDAHandler;
import org.ziniki.server.path.PathTree;
import org.ziniki.server.tda.WSReceiver;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.ziwsh.intf.WSProcessor;
import org.zinutils.streamedlogger.api.LabelBinder;

public class GrizzlyTDAServer
implements TDAServer {
    protected static final Logger logger = LoggerFactory.getLogger((String)"tdaserver");
    private final LabelBinder streamer;
    private final String streamName;
    private final HttpServer server;
    private final NetworkListener listener;
    private final ScheduledExecutorService ses;

    public GrizzlyTDAServer(int port) {
        this(null, port);
    }

    public GrizzlyTDAServer(SSLEngineConfigurator sslEngineConfig, int port) {
        this(sslEngineConfig, port, null, null);
    }

    public GrizzlyTDAServer(SSLEngineConfigurator sslEngineConfig, int port, LabelBinder streamer, String streamName) {
        this.streamer = streamer;
        this.streamName = streamName;
        this.server = new HttpServer();
        this.ses = new ScheduledThreadPoolExecutor(5);
        this.listener = new NetworkListener("grizzly", "0.0.0.0", port);
        logger.info("Opened TDA server on port " + port);
        if (sslEngineConfig != null) {
            this.listener.setSSLEngineConfig(sslEngineConfig);
            this.listener.setSecure(true);
            logger.info("Configured TDA server on port " + port + " to be secure using " + sslEngineConfig);
        }
        TCPNIOTransportBuilder builder = TCPNIOTransportBuilder.newInstance();
        TCPNIOTransport transport = builder.build();
        ThreadPoolConfig config = transport.getWorkerThreadPoolConfig();
        logger.info("Have default thread pool config " + config.toString().replaceAll("[\\n\\r]", "  "));
        this.listener.setTransport(transport);
        this.server.addListener(this.listener);
        WebSocketAddOn ws = new WebSocketAddOn();
        for (NetworkListener nl : this.server.getListeners()) {
            nl.registerAddOn((AddOn)ws);
        }
    }

    @Override
    public void httpMappingTree(PathTree<RequestProcessor> tree) {
        GrizzlyTDAHandler handler = new GrizzlyTDAHandler(this.streamer, this.streamName, this.ses, tree);
        this.server.getServerConfiguration().addHttpHandler((HttpHandler)handler, new HttpHandlerRegistration[]{HttpHandlerRegistration.builder().contextPath(null).urlPattern("/*").build()});
    }

    @Override
    public void wsMappingTree(CentralServerStore store, PathTree<WSProcessor> tree, NewConnectionHandler<? extends WSReceiver> handler) {
        if (store != null) {
            store.addWSHandler(tree, handler);
        } else if (!tree.isEmpty()) {
            throw new RuntimeException("Trying to add ws paths without providing ws configuration");
        }
    }

    public void start() throws IOException {
        try {
            this.server.start();
        }
        catch (BindException ex) {
            throw new BindException("Could not bind port " + this.getPort() + ": " + ex.getMessage());
        }
    }

    public boolean isAlive() {
        return this.server.isStarted();
    }

    public int getPort() {
        return this.listener.getPort();
    }

    public void stop() {
        this.server.shutdownNow();
    }

    public void stop(int time, TimeUnit unit) {
        this.server.shutdown((long)time, unit);
    }
}

