/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.grizzly;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.http.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.grizzly.GrizzlyBodyBlocker;
import org.ziniki.server.grizzly.GrizzlyNIOStream;
import org.ziniki.server.grizzly.GrizzlyNIOWriter;
import org.ziniki.server.grizzly.GrizzlyResponse;
import org.ziniki.servlet.basic.GrizzlyCookieSetter;
import org.ziniki.servlet.tda.CookieSetter;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.servlet.tda.ResponseReadyContinuation;

public class GrizzlyTDAResponder
implements Responder,
GrizzlyBodyBlocker {
    private final Logger logger = LoggerFactory.getLogger((String)"Grizzly");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
    private final ScheduledExecutorService ses;
    private final GrizzlyResponse r;
    private GrizzlyNIOWriter writer;
    private GrizzlyNIOStream stream;
    private boolean isReady = true;
    private ScheduledFuture<?> suspended;
    private final Map<String, Cookie> cookies = new TreeMap<String, Cookie>();
    private boolean cancelled = false;

    public GrizzlyTDAResponder(ScheduledExecutorService ses, GrizzlyResponse r) {
        this.ses = ses;
        this.r = r;
    }

    public int status() {
        return this.r.getStatus();
    }

    public void setStatus(int stat) {
        if (this.cancelled || this.suspended != null && this.suspended.isCancelled()) {
            this.logger.warn("Not setting status on response because already cancelled");
            return;
        }
        this.r.setStatus(stat);
    }

    public void setTimeout(int time, TimeUnit unit) {
        this.r.suspend();
        this.suspended = this.ses.schedule(new TimeOutResponse(null), (long)time, unit);
    }

    public void setTimeout(String message, int time, TimeUnit unit) {
        this.r.suspend();
        this.suspended = this.ses.schedule(new TimeOutResponse(message), (long)time, unit);
    }

    public void setContentType(String contentType) {
        this.r.setContentType(contentType);
    }

    public void setContentLength(long length) {
        this.r.setContentLengthLong(length);
    }

    public void setHeader(String name, String value) {
        this.r.setHeader(name, value);
    }

    public CookieSetter setCookie(String name, String value) {
        if (this.writer != null) {
            throw new RuntimeException("Cannot set cookies after writing starts");
        }
        Cookie c = new Cookie(name, value);
        this.logger.info("Setting cookie " + c.asServerCookieString());
        this.cookies.put(name, c);
        return new GrizzlyCookieSetter(c);
    }

    public void clearCookie(String named) {
        this.r.clearCookie(named);
    }

    public void redirectTo(String location) throws IOException {
        if (this.writer == null) {
            this.concludeHeaders();
        }
        this.r.redirectTo(location);
        if (this.suspended != null) {
            this.logger.info("cancelling timeout in GrizzlyResponse.redirectTo()");
            this.suspended.cancel(false);
            this.r.resume();
        }
    }

    private void concludeHeaders() {
        for (Cookie c : this.cookies.values()) {
            this.r.addHeader("Set-Cookie", c.asServerCookieString());
        }
    }

    public boolean write(String string, ResponseReadyContinuation rr) throws IOException, NotReadyException {
        char[] array = string.toCharArray();
        return this.write(array, 0, array.length, rr);
    }

    public boolean canWrite() {
        return this.isReady;
    }

    public boolean write(final char[] cbuf, final int off, final int len, final ResponseReadyContinuation rr) throws IOException, NotReadyException {
        if (this.writer == null) {
            this.concludeHeaders();
            this.writer = this.r.getNIOWriter();
        }
        if (!this.isReady) {
            throw new NotReadyException();
        }
        if (this.writer.canWrite()) {
            this.writer.write(cbuf, off, len);
            return true;
        }
        this.writer.notifyCanWrite(new WriteHandler(){

            public void onWritePossible() throws Exception {
                GrizzlyTDAResponder.this.writer.write(cbuf, off, len);
                GrizzlyTDAResponder.this.isReady = true;
                rr.responseReady();
            }

            public void onError(Throwable arg0) {
                rr.streamError(arg0);
            }
        });
        this.isReady = false;
        return false;
    }

    public boolean write(final byte[] buf, final int off, final int len, final ResponseReadyContinuation rr) throws IOException, NotReadyException {
        if (this.cancelled || this.suspended != null && this.suspended.isCancelled()) {
            this.logger.warn("Not writing response because already cancelled");
            return true;
        }
        if (this.stream == null) {
            this.concludeHeaders();
            this.stream = this.r.getNIOStream();
        }
        if (!this.isReady) {
            throw new NotReadyException();
        }
        if (this.stream.canWrite()) {
            this.stream.write(buf, off, len);
            return true;
        }
        this.stream.notifyCanWrite(new WriteHandler(){

            public void onWritePossible() throws Exception {
                GrizzlyTDAResponder.this.stream.write(buf, off, len);
                GrizzlyTDAResponder.this.isReady = true;
                rr.responseReady();
            }

            public void onError(Throwable arg0) {
                rr.streamError(arg0);
            }
        });
        this.isReady = false;
        return false;
    }

    public synchronized void done() {
        if (this.cancelled || this.suspended != null && this.suspended.isCancelled()) {
            this.logger.warn("Not sending response on done() because already cancelled");
            return;
        }
        if (this.writer == null && this.stream == null) {
            this.concludeHeaders();
            this.r.getNIOWriter().close();
        }
        if (this.suspended != null) {
            this.logger.info("cancelling timeout in GrizzlyResponse");
            this.suspended.cancel(false);
            this.r.resume();
        }
    }

    public void handleError(Throwable err) {
        if (this.cancelled || this.suspended != null && this.suspended.isCancelled()) {
            this.logger.warn("Not sending error response because already cancelled");
            return;
        }
        this.r.setStatus(500);
        char[] s = err.getMessage().toCharArray();
        if (this.writer == null) {
            this.setContentLength(s.length);
            this.concludeHeaders();
        }
        try {
            this.write(s, 0, s.length, null);
        }
        catch (IOException | NotReadyException throwable) {
            // empty catch block
        }
        this.done();
    }

    @Override
    public void blockForBody() {
        if (this.suspended == null) {
            this.r.suspend();
        }
    }

    @Override
    public void bodyRead() {
        if (this.suspended == null) {
            this.r.resume();
        }
    }

    public class TimeOutResponse
    implements Runnable {
        private final String message;
        private final Date asked = new Date();

        public TimeOutResponse(String message) {
            this.message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GrizzlyTDAResponder.this.logger.warn("TimeOutResponse is firing since " + sdf.format(this.asked) + (String)(this.message != null ? " " + this.message : ""));
            GrizzlyTDAResponder grizzlyTDAResponder = GrizzlyTDAResponder.this;
            synchronized (grizzlyTDAResponder) {
                if (GrizzlyTDAResponder.this.suspended.isCancelled()) {
                    GrizzlyTDAResponder.this.logger.warn("TimeOutResponse cancelled while firing");
                    return;
                }
                GrizzlyTDAResponder.this.r.setStatus(500);
                GrizzlyTDAResponder.this.r.resume();
                GrizzlyTDAResponder.this.logger.warn("Sent 500 and cancelled request");
                GrizzlyTDAResponder.this.cancelled = true;
            }
        }
    }
}

