/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.grizzly;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.TDADispatcher;
import org.ziniki.server.grizzly.GrizzlyAsyncBodyReader;
import org.ziniki.server.grizzly.GrizzlyBodyBlocker;
import org.ziniki.server.grizzly.GrizzlyNIOSource;
import org.ziniki.server.grizzly.GrizzlyNIOStreamSource;
import org.ziniki.server.grizzly.GrizzlyResponseTrampoline;
import org.ziniki.server.grizzly.GrizzlyTDAConfiguration;
import org.ziniki.server.grizzly.GrizzlyTDAResponder;
import org.ziniki.server.path.PathResolutionException;
import org.ziniki.server.path.PathTree;
import org.ziniki.server.tda.ProvideHostInfo;
import org.ziniki.server.tda.RequestMethod;
import org.ziniki.servlet.tda.BodyChunkHandler;
import org.ziniki.servlet.tda.CookieAware;
import org.ziniki.servlet.tda.NeedBaseURI;
import org.ziniki.servlet.tda.NeedFullURLWithQuery;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.ProvideHeaders;
import org.ziniki.servlet.tda.RequestPathParameters;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.RequestQueryAndPostParameters;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.servlet.tda.TDAConfiguration;
import org.zinutils.collections.CollectionUtils;
import org.zinutils.streamedlogger.api.LabelBinder;
import org.zinutils.utils.FileUtils;

public class GrizzlyTDAHandler
extends HttpHandler
implements TDADispatcher {
    static final Logger logger = LoggerFactory.getLogger((String)"tdaserver");
    private final LabelBinder streamer;
    private final String streamName;
    private final ScheduledExecutorService ses;
    private final PathTree<RequestProcessor> mappingTree;

    public GrizzlyTDAHandler(ScheduledExecutorService ses, PathTree<RequestProcessor> tree) {
        this(null, null, ses, tree);
    }

    public GrizzlyTDAHandler(LabelBinder streamer, String streamName, ScheduledExecutorService ses, PathTree<RequestProcessor> tree) {
        this.streamer = streamer;
        this.streamName = streamName;
        this.ses = ses;
        this.mappingTree = tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request request, Response response) throws Exception {
        if (this.streamer != null) {
            this.streamer.bindLabelToThread(this.streamName);
        }
        String method = request.getMethod().getMethodString();
        String path = request.getPathInfo();
        GrizzlyTDAResponder responder = null;
        try {
            GrizzlyTDAConfiguration config = new GrizzlyTDAConfiguration();
            String query = request.getQueryString();
            Map parameters = request.getParameterMap();
            String baseUri = request.getRequestURL().toString().replace(path, "");
            StringBuilder requestURL = request.getRequestURL();
            if (query != null) {
                requestURL.append("?");
                requestURL.append(query);
            }
            Cookie[] cookies = request.getCookies();
            responder = new GrizzlyTDAResponder(this.ses, new GrizzlyResponseTrampoline(response));
            this.handleRequest(config, request.getServerName(), request.getServerPort(), method, baseUri, path, requestURL.toString(), this.allHeaders(request), parameters, cookies, new GrizzlyNIOStreamSource(request.getNIOInputStream()), responder);
        }
        catch (PathResolutionException ex) {
            logger.info("Path not found: " + method + " " + path);
            logger.info(new String(FileUtils.readAllStream((InputStream)request.getInputStream())));
            response.setStatus(404);
        }
        catch (Exception ex) {
            logger.error("error processing request " + request, (Throwable)ex);
            responder.handleError(ex);
        }
        finally {
            if (this.streamer != null) {
                this.streamer.bindLabelToThread(null);
            }
        }
    }

    private Map<String, List<String>> allHeaders(Request request) {
        TreeMap<String, List<String>> ret = new TreeMap<String, List<String>>();
        for (String h : request.getHeaderNames()) {
            ret.put(h, CollectionUtils.array(request.getHeaders(h).iterator()));
        }
        return ret;
    }

    @Override
    public void handleRequest(TDAConfiguration config, String host, int port, String method, String baseUri, String path, String pathQuery, Map<String, List<String>> headers, Map<String, String[]> parameters, Cookie[] cookies, GrizzlyNIOSource body, Responder responder) throws Exception {
        RequestProcessor instance = this.mappingTree.makeHandler(config, path);
        if (instance == null) {
            responder.setStatus(404);
            responder.write("no handler found for " + path, null);
            responder.done();
            return;
        }
        if (instance instanceof ProvideHostInfo) {
            ((ProvideHostInfo)instance).provideHost(host, port);
        }
        if (instance instanceof RequestMethod) {
            ((RequestMethod)instance).requestMethod(method);
        }
        if (instance instanceof NeedFullURLWithQuery) {
            ((NeedFullURLWithQuery)instance).fullURLWithQuery(pathQuery);
        }
        if (instance instanceof NeedBaseURI) {
            ((NeedBaseURI)instance).baseUri(baseUri);
        }
        if (instance instanceof ProvideHeaders) {
            ProvideHeaders h = (ProvideHeaders)instance;
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                for (String s : entry.getValue()) {
                    h.header(entry.getKey(), s);
                }
            }
        }
        if (instance instanceof RequestPathParameters) {
            this.mappingTree.populate((RequestPathParameters)instance, path);
        }
        if (instance instanceof RequestQueryAndPostParameters) {
            RequestQueryAndPostParameters qpp = (RequestQueryAndPostParameters)instance;
            for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
                for (String string : (String[])entry.getValue()) {
                    logger.debug("offering parameter " + string + " for " + entry.getKey());
                    qpp.stringValue(entry.getKey(), string, ParameterSource.QUERYPOST);
                }
            }
        }
        if (instance instanceof CookieAware && cookies != null) {
            CookieAware ca = (CookieAware)instance;
            String[] wanted = ca.cookiesWanted();
            logger.info("have cookies " + Arrays.asList(cookies) + " and want " + Arrays.asList(wanted));
            if (wanted != null) {
                block4: for (Cookie c : cookies) {
                    logger.info("have received cookie " + c.getName());
                    for (String s : wanted) {
                        if (!c.getName().equals(s)) continue;
                        logger.info("setting cookie " + c.getName() + " as " + c.getValue());
                        ca.cookie(s, c.getValue());
                        continue block4;
                    }
                }
            }
        }
        logger.info("Handling " + method + " " + pathQuery + " with " + instance);
        instance.process(responder);
        if (instance instanceof BodyChunkHandler) {
            List<String> list;
            long cl = Long.MAX_VALUE;
            if (headers.containsKey("content-length") && (list = headers.get("content-length")).size() > 0) {
                cl = Long.parseLong(list.get(0));
            }
            long l = cl;
            GrizzlyBodyBlocker gr = (GrizzlyBodyBlocker)responder;
            gr.blockForBody();
            BodyChunkHandler bch = (BodyChunkHandler)instance;
            GrizzlyAsyncBodyReader grizzlyAsyncBodyReader = new GrizzlyAsyncBodyReader(body, l, gr, bch);
            if (body.hasRemaining()) {
                grizzlyAsyncBodyReader.onDataAvailable();
            }
            if (!grizzlyAsyncBodyReader.doneDone) {
                body.notifyAvailable(grizzlyAsyncBodyReader);
            }
        }
    }
}

