/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.grizzly;

import java.io.IOException;
import java.util.Locale;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.io.NIOWriter;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.grizzly.GrizzlyNIOStream;
import org.ziniki.server.grizzly.GrizzlyNIOStreamTrampoline;
import org.ziniki.server.grizzly.GrizzlyNIOWriter;
import org.ziniki.server.grizzly.GrizzlyNIOWriterTrampoline;
import org.ziniki.server.grizzly.GrizzlyResponse;
import org.zinutils.exceptions.CantHappenException;

public class GrizzlyResponseTrampoline
implements GrizzlyResponse {
    protected static final Logger logger = LoggerFactory.getLogger((String)"tdaserver");
    private final Response delegate;

    public GrizzlyResponseTrampoline(Response response) {
        if (response.getResponse() == null) {
            throw new CantHappenException("response packet is null");
        }
        this.delegate = response;
    }

    @Override
    public int getStatus() {
        return this.delegate.getStatus();
    }

    @Override
    public void setStatus(int stat) {
        this.delegate.setStatus(stat);
    }

    @Override
    public GrizzlyNIOWriter getNIOWriter() {
        return new GrizzlyNIOWriterTrampoline(this.delegate.getNIOWriter());
    }

    @Override
    public GrizzlyNIOStream getNIOStream() {
        return new GrizzlyNIOStreamTrampoline(this.delegate.getNIOOutputStream());
    }

    @Override
    public void suspend() {
        this.delegate.suspend();
    }

    @Override
    public void resume() {
        this.delegate.resume();
    }

    @Override
    public void setContentType(String contentType) {
        this.delegate.setContentType(contentType);
    }

    @Override
    public void setContentLengthLong(long length) {
        this.delegate.setContentLengthLong(length);
    }

    @Override
    public void addHeader(String name, String value) {
        this.delegate.addHeader(name, value);
    }

    @Override
    public void setHeader(String name, String value) {
        this.delegate.setHeader(name, value);
    }

    @Override
    public void clearCookie(String named) {
        Cookie c = new Cookie(named, "");
        c.setMaxAge(0);
        this.delegate.addCookie(c);
    }

    @Override
    public void redirectTo(String location) throws IOException {
        if (this.delegate.getResponse() != null && this.delegate.isCommitted()) {
            throw new IllegalStateException("Cannot redirect after commit");
        }
        logger.info("Sending redirect to " + location);
        this.delegate.setStatus(HttpStatus.FOUND_302);
        this.delegate.setHeader(Header.Location, location);
        this.delegate.setContentType("text/html");
        this.delegate.setLocale(Locale.getDefault());
        try {
            NIOWriter w = this.delegate.getNIOWriter();
            w.write("<html><head><title>Document Moved</title></head><body>The document has moved to <a href='" + Response.filter((String)location) + "'></body></html>");
            w.flush();
        }
        catch (IOException ex) {
            logger.warn("Could not write the explanatory text");
        }
        this.delegate.finish();
    }
}

