/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.grizzly;

import org.glassfish.grizzly.ReadHandler;
import org.ziniki.server.grizzly.GrizzlyBodyBlocker;
import org.ziniki.server.grizzly.GrizzlyNIOSource;
import org.ziniki.server.grizzly.GrizzlyTDAHandler;
import org.ziniki.servlet.tda.BodyChunkHandler;
import org.ziniki.servlet.tda.BodyFlowControl;
import org.zinutils.utils.Crypto;

final class GrizzlyAsyncBodyReader
implements ReadHandler {
    private final GrizzlyNIOSource bodyIS;
    private final long contentLength;
    private final GrizzlyBodyBlocker gr;
    private final BodyChunkHandler bch;
    long total = 0L;
    byte[] bs = new byte[64000];
    private boolean paused = false;
    private boolean allDataRead = false;
    boolean doneDone = false;

    GrizzlyAsyncBodyReader(GrizzlyNIOSource bodyIS, long contentLength, GrizzlyBodyBlocker gr, BodyChunkHandler bch) {
        this.bodyIS = bodyIS;
        this.contentLength = contentLength;
        this.gr = gr;
        this.bch = bch;
    }

    public void onDataAvailable() throws Exception {
        if (this.paused) {
            return;
        }
        do {
            int toRead;
            if (this.contentLength - this.total < (long)(toRead = this.bs.length)) {
                toRead = (int)(this.contentLength - this.total);
            }
            int k = 0;
            if (toRead > 0) {
                k = this.bodyIS.read(this.bs, 0, toRead);
                this.total += (long)k;
            }
            if (k <= 0) {
                if (this.allDataRead || this.total >= this.contentLength) {
                    this.done();
                }
                return;
            }
            GrizzlyTDAHandler.logger.info("hash = " + Crypto.hash((byte[])this.bs));
            BodyFlowControl flow = new BodyFlowControl(){

                public void pause() {
                    GrizzlyAsyncBodyReader.this.paused = true;
                }

                public void resume() throws Exception {
                    GrizzlyAsyncBodyReader.this.paused = false;
                    GrizzlyAsyncBodyReader.this.onDataAvailable();
                }
            };
            this.bch.chunk(this.bs, 0, k, flow);
        } while (!this.allDataRead);
        this.done();
    }

    public void onAllDataRead() throws Exception {
        this.allDataRead = true;
        if (this.paused) {
            return;
        }
        this.done();
    }

    public void onError(Throwable e) {
        GrizzlyTDAHandler.logger.error("Error encountered in TDAHandler", e);
        this.bch.error(e);
        this.done();
    }

    private synchronized void done() {
        if (!this.doneDone) {
            this.doneDone = true;
            this.bch.bodyDone();
            this.gr.bodyRead();
        }
    }
}

