/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.di;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jettison.json.JSONObject;
import org.ziniki.server.di.Extractor;
import org.ziniki.server.di.Instantiatable;

public class ReferenceExtractor
implements Extractor,
Comparable<ReferenceExtractor> {
    private final String actualName;

    public ReferenceExtractor(String ref) {
        if (!ref.startsWith("_") || !ref.endsWith("_")) {
            throw new RuntimeException("requires a reference, not " + ref);
        }
        this.actualName = ref.substring(1, ref.length() - 1);
    }

    @Override
    public String assertValidity(Map<String, Object> items) {
        Object ret = items.get(this.actualName);
        if (ret == null) {
            return "there is no definition for " + this.actualName;
        }
        while (ret instanceof String) {
            String rr = (String)ret;
            if (!rr.startsWith("_") || !rr.endsWith("_")) continue;
            ret = items.get(rr.substring(1, rr.length() - 1));
        }
        if (!(ret instanceof File || ret instanceof Collection || ret instanceof Map || ret instanceof Instantiatable || ret == JSONObject.EXPLICIT_NULL)) {
            return this.actualName + " is not a configured object";
        }
        return null;
    }

    @Override
    public Object extract(Map<String, Object> items) {
        Object ret = items.get(this.actualName);
        if (ret == null) {
            throw new RuntimeException("there is no definition for " + this.actualName);
        }
        if (ret == JSONObject.EXPLICIT_NULL) {
            return null;
        }
        if (ret instanceof File || ret instanceof Collection || ret instanceof Map) {
            return ret;
        }
        if (!(ret instanceof Instantiatable)) {
            throw new RuntimeException(this.actualName + " is not a configured object");
        }
        return ((Instantiatable)ret).getInstance();
    }

    public String actualName() {
        return this.actualName;
    }

    @Override
    public int compareTo(ReferenceExtractor o) {
        return this.actualName.compareTo(o.actualName);
    }

    public String toString() {
        return "Ref[" + this.actualName + "]";
    }
}

