/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.di;

import java.util.Map;
import org.ziniki.server.di.ConfigException;
import org.ziniki.server.di.Extractor;

class PropertyExtractor
implements Extractor {
    private final String token;

    public PropertyExtractor(String token) {
        if (!token.startsWith("$") || !token.endsWith("$")) {
            throw new ConfigException("requires a property name, not " + token);
        }
        this.token = token.substring(1, token.length() - 1);
    }

    @Override
    public String assertValidity(Map<String, Object> items) {
        String ret = System.getenv(this.token);
        if (ret != null) {
            return null;
        }
        ret = System.getProperty(this.token);
        if (ret != null) {
            return null;
        }
        return "There is no env or property definition for " + this.token;
    }

    @Override
    public Object extract(Map<String, Object> items) {
        String ret = System.getenv(this.token);
        if (ret != null) {
            return ret;
        }
        ret = System.getProperty(this.token);
        if (ret != null) {
            return ret;
        }
        throw new ConfigException("There is no env or property definition for " + this.token);
    }
}

