/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.di;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.di.ConfigCascadeException;
import org.ziniki.server.di.ConfigException;
import org.ziniki.server.di.ConfigExtractor;
import org.ziniki.server.di.ConstantExtractor;
import org.ziniki.server.di.ConstantFormatter;
import org.ziniki.server.di.ErrorHandler;
import org.ziniki.server.di.Extractor;
import org.ziniki.server.di.IgnoreException;
import org.ziniki.server.di.Instantiatable;
import org.ziniki.server.di.InstantiatorFactory;
import org.ziniki.server.di.InternalExtractor;
import org.ziniki.server.di.PropertyExtractor;
import org.ziniki.server.di.ReferenceExtractor;
import org.ziniki.server.di.ValueExtractor;
import org.ziniki.servlet.tda.TDAConfiguration;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.reflection.Reflection;

public class Instantiator
implements Instantiatable {
    protected final Logger logger = LoggerFactory.getLogger((String)"DI");
    private final String name;
    private final Set<ReferenceExtractor> refs = new TreeSet<ReferenceExtractor>();
    private final ArrayList<Extractor> args;
    private final Class<?> clz;
    private final Constructor<?> ctor;
    private Object instance;
    private final List<ProvidesInstance> provides = new ArrayList<ProvidesInstance>();

    public Instantiator(String name, Map<String, Object> config) {
        this("args", name, config, null, e -> {
            throw new RuntimeException(e);
        });
    }

    public Instantiator(String file, String name, Map<String, Object> config, Map<String, Object> items, ErrorHandler eh) {
        this.name = name;
        if (!config.containsKey("class")) {
            throw new RuntimeException("Must specify 'class'");
        }
        String clzName = (String)config.get("class");
        config.remove("class");
        this.logger.info("  defining " + name + " from " + file + " of class " + clzName + " with " + config);
        try {
            if (clzName.startsWith("%%")) {
                clzName = (String)new ConstantFormatter(clzName).extract(items);
            } else if (clzName.startsWith("%")) {
                clzName = (String)new ConstantExtractor(clzName).extract(items);
            }
            try {
                this.clz = Class.forName(clzName);
            }
            catch (ClassNotFoundException ex) {
                eh.error("Cannot create " + name + ": " + clzName + " does not exist");
                throw new IgnoreException();
            }
            List<Constructor<?>> ctors = Instantiator.findMatchingCtors(name, this.clz, eh);
            this.logger.debug("  found DI constructors " + ctors);
            this.ctor = this.bestMatchingCtor(ctors, config);
            this.logger.debug("  chose constructor " + this.ctor);
            Class<?>[] parameterTypes = this.ctor.getParameterTypes();
            Annotation[][] anns = this.ctor.getParameterAnnotations();
            this.args = new ArrayList();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Extractor extr;
                String param;
                block34: {
                    Class<?> pt = parameterTypes[i];
                    Annotation[] p = anns[i];
                    param = null;
                    for (Annotation q : p) {
                        if (!(q instanceof Param)) continue;
                        param = ((Param)q).value();
                    }
                    if (param == null) {
                        if (TDAConfiguration.class.isAssignableFrom(pt)) {
                            this.args.add(new ConfigExtractor());
                            continue;
                        }
                        eh.error("Trying to create " + name + ": constructor for " + this.clz + " " + this.ctor + " missing @Param annotation(s)");
                        continue;
                    }
                    if ("instantiatableName".equals(param) && pt == String.class) {
                        this.args.add(new InternalExtractor(name));
                        continue;
                    }
                    if (!config.containsKey(param)) {
                        eh.error("Defining " + name + ": there is no definition for parameter " + param);
                    }
                    this.logger.debug("  will pull " + param + " from item " + config.get(param));
                    Object ref = config.get(param);
                    if (pt != Integer.class && pt != String.class && !pt.isPrimitive()) {
                        if (ref instanceof String) {
                            try {
                                extr = new ReferenceExtractor((String)ref);
                                this.refs.add((ReferenceExtractor)extr);
                                break block34;
                            }
                            catch (Exception ex) {
                                eh.error("Defining " + name + ": reference parameter " + param + " " + ex.getMessage());
                                continue;
                            }
                        }
                        extr = new ValueExtractor(ref);
                    } else if (ref instanceof String) {
                        String rr = (String)ref;
                        if (rr.startsWith("%%")) {
                            extr = new ConstantFormatter(rr);
                        } else if (rr.startsWith("%")) {
                            extr = new ConstantExtractor(rr);
                        } else if (rr.startsWith("$")) {
                            extr = new PropertyExtractor(rr);
                        } else {
                            if (rr.startsWith("_")) {
                                eh.error(name + "." + param + " cannot be an object reference: " + ref);
                                config.remove(param);
                                continue;
                            }
                            extr = new ValueExtractor(ref);
                        }
                    } else {
                        extr = new ValueExtractor(ref);
                    }
                }
                this.args.add(extr);
                config.remove(param);
            }
            if (config.containsKey("provideTo")) {
                Object o = config.remove("provideTo");
                if (o instanceof JSONArray) {
                    JSONArray ja = (JSONArray)o;
                    for (int i = 0; i < ja.length(); ++i) {
                        this.doProvide(name, eh, ja.getJSONObject(i));
                    }
                } else {
                    this.doProvide(name, eh, (JSONObject)o);
                }
            }
            if (!config.isEmpty()) {
                eh.error("Unused config parameters in " + name + ": " + config.keySet());
            }
        }
        catch (IgnoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            eh.error(ex.toString());
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    private void doProvide(String name, ErrorHandler eh, JSONObject provideTo) throws JSONException {
        String store = provideTo.getString("store");
        String meth = provideTo.getString("method");
        this.logger.debug("Will provide " + name + " to " + store + "." + meth);
        try {
            ReferenceExtractor extr = new ReferenceExtractor(store);
            this.provides.add(new ProvidesInstance(extr, meth));
        }
        catch (Exception ex) {
            eh.error("Defining " + name + ": no object " + store + " " + ex.getMessage());
        }
    }

    private static List<Constructor<?>> findMatchingCtors(String name, Class<?> clz, ErrorHandler eh) {
        Constructor<?>[] ctors = clz.getConstructors();
        if (ctors == null || ctors.length == 0) {
            throw new RuntimeException("There are no constructors in " + clz);
        }
        ArrayList ret = new ArrayList();
        for (Constructor<?> ctor : ctors) {
            Annotation[][] anns = ctor.getParameterAnnotations();
            boolean haveParamOnAll = true;
            for (int i = 0; i < anns.length; ++i) {
                boolean haveParam = false;
                for (int j = 0; j < anns[i].length; ++j) {
                    if (!(anns[i][j] instanceof Param)) continue;
                    haveParam = true;
                    break;
                }
                haveParamOnAll &= haveParam;
            }
            if (!haveParamOnAll) continue;
            ret.add(ctor);
        }
        if (ret.isEmpty()) {
            eh.error(name + ": none of the constructors for " + clz + " has @Param annotations on all parameters");
            throw new IgnoreException();
        }
        return ret;
    }

    private Constructor<?> bestMatchingCtor(List<Constructor<?>> ctors, Map<String, Object> config) {
        ArrayList matching = new ArrayList();
        for (Constructor<?> c : ctors) {
            this.logger.debug("Looking at " + c + " with " + config.keySet());
            if (!this.ctorMatch(c, config)) continue;
            matching.add(c);
        }
        if (matching.size() == 1) {
            return (Constructor)matching.get(0);
        }
        if (matching.isEmpty()) {
            throw new ConfigException("None of the constructors for " + ctors.get(0).getName() + " has params for " + config.keySet());
        }
        throw new ConfigException("Multiple constructors for " + ctors.get(0).getName() + " have params for " + config.keySet() + ": " + matching);
    }

    private boolean ctorMatch(Constructor<?> c, Map<String, Object> config) {
        TreeSet<String> have = new TreeSet<String>(config.keySet());
        Annotation[][] anns = c.getParameterAnnotations();
        boolean missing = false;
        Annotation[][] annotationArray = anns;
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] a;
            for (Annotation t : a = annotationArray[i]) {
                String key;
                if (t.annotationType() != Param.class || (key = ((Param)t).value()).equals("instantiatableName")) continue;
                if (config.containsKey(key)) {
                    have.remove(key);
                    continue;
                }
                this.logger.info("  cannot use " + c + ": there is no config field for " + key);
                missing = true;
            }
        }
        have.remove("provideTo");
        this.logger.debug("  have = " + have + " missing = " + missing);
        return !missing && have.isEmpty();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean willBeA(Class<?> parent, Map<String, Object> items) {
        return parent.isAssignableFrom(this.clz);
    }

    @Override
    public Set<ReferenceExtractor> getReferences() {
        return this.refs;
    }

    @Override
    public void assertValidity(Map<String, Object> items, ErrorHandler eh) {
        for (Extractor e : this.args) {
            String err = e.assertValidity(items);
            if (err == null) continue;
            eh.error("In " + this.name + ", " + err);
        }
    }

    @Override
    public void instantiateSingleton(Map<String, Object> items) throws Throwable {
        if (this.instance == null) {
            try {
                this.instance = this.instantiateCommon(items);
                this.logger.info("Instance for " + this.name + " is " + this.instance);
            }
            catch (Throwable t) {
                this.logger.info("creating " + this.name + " threw", t);
                throw t;
            }
        }
    }

    @Override
    public <T> T instantiateSeparate(Map<String, Object> items) {
        try {
            T ret = this.instantiateCommon(items);
            this.provideMe(ret, items);
            return ret;
        }
        catch (Throwable ex) {
            this.logger.info("Could not create " + this.name + " with " + items, ex);
            return null;
        }
    }

    private <T> T instantiateCommon(Map<String, Object> items) throws Throwable {
        this.logger.info("Instantiating " + this.name);
        this.logger.debug("Using " + items);
        Object error = null;
        Object[] arr = new Object[this.args.size()];
        for (int i = 0; i < this.args.size(); ++i) {
            Class<File> pt;
            Extractor ai = this.args.get(i);
            Object v = ai.extract(items);
            if (v instanceof JSONArray) {
                String tmp = this.replaceStrings(items, (JSONArray)v);
                error = error != null ? error : tmp;
            }
            arr[i] = v;
            this.logger.debug("  with " + ai + " as " + arr[i]);
            if (arr[i] == JSONObject.NULL || arr[i] == JSONObject.EXPLICIT_NULL) {
                arr[i] = null;
                continue;
            }
            if (arr[i] == null || (pt = this.ctor.getParameterTypes()[i]).isInstance(arr[i])) continue;
            if (pt.isPrimitive()) {
                if (pt == Integer.TYPE && Integer.class.isInstance(arr[i]) || pt == Long.TYPE && Long.class.isInstance(arr[i]) || pt == Long.TYPE && Integer.class.isInstance(arr[i]) || pt == Boolean.TYPE && Boolean.class.isInstance(arr[i])) continue;
                error = "Cannot assign arg " + i + " of " + this.name + " from " + ai + ": " + pt + " <- " + arr[i].getClass();
                this.logger.error((String)error);
                continue;
            }
            if (pt.isAssignableFrom(File.class) && String.class.isInstance(arr[i])) {
                arr[i] = new File((String)arr[i]);
                continue;
            }
            error = "Cannot assign arg " + i + " of " + this.name + " from " + ai + ": " + pt + " <- " + arr[i].getClass();
            this.logger.error((String)error);
        }
        if (error != null) {
            throw new ConfigException((String)error);
        }
        try {
            Object tmp = this.ctor.newInstance(arr);
            if (tmp instanceof InstantiatorFactory) {
                Object tmp2 = ((InstantiatorFactory)tmp).create();
                tmp = tmp2;
            }
            return (T)tmp;
        }
        catch (InvocationTargetException ex) {
            this.logger.info("Error creating " + this.name, ex.getCause());
            throw ex.getCause();
        }
    }

    @Override
    public void provideMe(Object inst, Map<String, Object> items) {
        for (ProvidesInstance pi : this.provides) {
            this.logger.info("Providing " + this + " to " + pi.extr + "." + pi.method);
            try {
                Object provideTo = pi.extr.extract(items);
                Reflection.call((Object)provideTo, (String)pi.method, (Object[])new Object[]{inst});
            }
            catch (ConfigException ex) {
                this.logger.error("Could not provide to " + pi.extr + " because it is not configured");
            }
        }
    }

    private String replaceStrings(Map<String, Object> items, JSONArray arr) throws JSONException {
        StringBuilder error = new StringBuilder();
        for (int i = 0; i < arr.length(); ++i) {
            String tmp;
            Object ai = arr.get(i);
            if (ai instanceof String) {
                String s = (String)ai;
                if (!s.startsWith("%") || !s.endsWith("%")) continue;
                arr.put(i, this.extract(items, s, error));
                continue;
            }
            if (ai instanceof JSONArray) {
                tmp = this.replaceStrings(items, (JSONArray)ai);
                error.append(tmp != null ? tmp : "");
                continue;
            }
            if (!(ai instanceof JSONObject)) continue;
            tmp = this.replaceStrings(items, (JSONObject)ai);
            error.append(tmp != null ? tmp : "");
        }
        return error.length() == 0 ? null : error.toString();
    }

    private String replaceStrings(Map<String, Object> items, JSONObject obj) throws JSONException {
        StringBuilder error = new StringBuilder();
        Iterator it = obj.keys();
        while (it.hasNext()) {
            String tmp;
            String fld = (String)it.next();
            Object as = obj.get(fld);
            if (as instanceof String) {
                String s = (String)as;
                if (!s.startsWith("%") || !s.endsWith("%")) continue;
                obj.put(fld, this.extract(items, s, error));
                continue;
            }
            if (as instanceof JSONArray) {
                tmp = this.replaceStrings(items, (JSONArray)as);
                error.append(tmp != null ? tmp : "");
                continue;
            }
            if (!(as instanceof JSONObject)) continue;
            tmp = this.replaceStrings(items, (JSONObject)as);
            error.append(tmp != null ? tmp : "");
        }
        return error.length() == 0 ? null : error.toString();
    }

    private Object extract(Map<String, Object> items, String s, StringBuilder error) {
        Extractor foo;
        if (s.startsWith("%%")) {
            foo = new ConstantFormatter(s);
        } else if (s.startsWith("%")) {
            foo = new ConstantExtractor(s);
        } else {
            return s;
        }
        String err = foo.assertValidity(items);
        if (err != null) {
            error.append(err + "\n");
            return null;
        }
        return foo.extract(items);
    }

    @Override
    public boolean hasInstance() {
        return this.instance != null;
    }

    @Override
    public <T> T getInstance() {
        if (this.instance == null) {
            throw new ConfigCascadeException("No instance created for " + this.name);
        }
        return (T)this.instance;
    }

    public String toString() {
        return "Instantiator[" + this.name + ":" + this.clz + "]";
    }

    public class ProvidesInstance {
        private final Extractor extr;
        private final String method;

        public ProvidesInstance(Extractor extr, String method) {
            this.extr = extr;
            this.method = method;
        }
    }
}

