/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.di;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.di.ErrorHandler;
import org.ziniki.server.di.Instantiatable;
import org.ziniki.server.di.Instantiator;
import org.ziniki.server.di.ReferenceExtractor;
import org.zinutils.exceptions.NotImplementedException;

public class GetFrom
implements Instantiatable {
    protected final Logger logger = LoggerFactory.getLogger((String)"DI");
    private ReferenceExtractor getfrom;
    private String method;
    private String name;
    private Method meth;
    private Object parent;
    private Object value;

    public GetFrom(String name, ReferenceExtractor getfrom, String method) {
        this.name = name;
        this.getfrom = getfrom;
        this.method = method;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void assertValidity(Map<String, Object> items, ErrorHandler eh) {
        String ret = this.getfrom.assertValidity(items);
        if (ret != null) {
            eh.error(ret);
        }
    }

    @Override
    public Set<ReferenceExtractor> getReferences() {
        HashSet<ReferenceExtractor> ret = new HashSet<ReferenceExtractor>();
        ret.add(this.getfrom);
        return ret;
    }

    @Override
    public boolean willBeA(Class<?> clz, Map<String, Object> items) {
        if (this.meth == null) {
            this.parent = this.getfrom.extract(items);
            this.logger.info("WillBeA.GetFrom(" + this.name + "," + this.getfrom + "," + this.method + ") has meth " + this.meth + " and parent " + this.parent);
            if (this.parent == null) {
                return false;
            }
            if (this.parent instanceof Instantiator) {
                this.parent = ((Instantiator)this.parent).getInstance();
            }
            this.logger.info("parent class is " + this.parent.getClass());
            for (Method m : this.parent.getClass().getMethods()) {
                this.logger.info("  have method " + m.getName());
                if (!m.getName().equals(this.method)) continue;
                this.meth = m;
                break;
            }
            if (this.meth == null) {
                return false;
            }
        }
        return clz.isAssignableFrom(this.meth.getReturnType());
    }

    @Override
    public void instantiateSingleton(Map<String, Object> ic) throws Exception {
        this.logger.info("GetFrom(" + this.name + "," + this.getfrom + "," + this.method + ") has meth " + this.meth + " and parent " + this.parent);
        if (this.value == null && this.meth != null) {
            this.value = this.meth.invoke(this.parent, new Object[0]);
        }
        this.logger.info("GetFrom returns " + this.value + "!!!!!!!");
    }

    @Override
    public <T> T instantiateSeparate(Map<String, Object> ic) {
        throw new NotImplementedException("I think this is reasonable - I don't see how to implement this");
    }

    @Override
    public boolean hasInstance() {
        return this.value != null;
    }

    @Override
    public void provideMe(Object inst, Map<String, Object> items) {
    }

    @Override
    public <T> T getInstance() {
        return (T)this.value;
    }
}

