/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.di;

import java.util.Map;
import org.ziniki.server.di.ConfigException;
import org.ziniki.server.di.Extractor;
import org.ziniki.server.di.Instantiator;

public class ConstantFormatter
implements Extractor {
    private final String token;

    public ConstantFormatter(String token) {
        if (!token.startsWith("%%") || !token.endsWith("%%")) {
            throw new ConfigException("requires a format string, not " + token);
        }
        this.token = token.substring(2, token.length() - 2);
    }

    @Override
    public String assertValidity(Map<String, Object> items) {
        String[] parts = this.token.split("%");
        for (int i = 1; i < parts.length; i += 2) {
            Object ri = items.get(parts[i]);
            if (ri == null) {
                return "there is no definition for " + parts[i];
            }
            if (ri instanceof Instantiator) {
                return parts[i] + " is a configured object";
            }
            if (!(ri instanceof Extractor)) continue;
            return ((Extractor)ri).assertValidity(items);
        }
        return null;
    }

    @Override
    public Object extract(Map<String, Object> items) {
        StringBuilder sb = new StringBuilder();
        String[] parts = this.token.split("%");
        for (int i = 0; i < parts.length; ++i) {
            if (i % 2 == 0) {
                sb.append(parts[i]);
                continue;
            }
            Object ri = items.get(parts[i]);
            if (ri == null) {
                throw new ConfigException("there is no definition for " + parts[i]);
            }
            if (ri instanceof Instantiator) {
                throw new ConfigException(parts[i] + " is a configured object");
            }
            if (ri instanceof Extractor) {
                sb.append(((Extractor)ri).extract(items));
                continue;
            }
            sb.append(ri);
        }
        return sb.toString();
    }
}

