/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.di;

import java.util.Map;
import org.ziniki.server.di.ConfigException;
import org.ziniki.server.di.Extractor;
import org.ziniki.server.di.Instantiator;

public class ConstantExtractor
implements Extractor {
    private final String token;

    public ConstantExtractor(String token) {
        if (!token.startsWith("%") || !token.endsWith("%")) {
            throw new ConfigException("requires a token, not " + token);
        }
        this.token = token.substring(1, token.length() - 1);
    }

    @Override
    public String assertValidity(Map<String, Object> items) {
        Object ret = items.get(this.token);
        if (ret == null) {
            return "there is no definition for " + this.token;
        }
        if (ret instanceof Instantiator) {
            return this.token + " is a configured object";
        }
        if (ret instanceof Extractor) {
            return ((Extractor)ret).assertValidity(items);
        }
        return null;
    }

    @Override
    public Object extract(Map<String, Object> items) {
        Object ret = items.get(this.token);
        if (ret == null) {
            throw new ConfigException("there is no definition for " + this.token);
        }
        if (ret instanceof Instantiator) {
            throw new ConfigException(this.token + " is a configured object");
        }
        if (ret instanceof Extractor) {
            return ((Extractor)ret).extract(items);
        }
        return ret;
    }
}

