/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplaceTransitGatewayRouteRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ReplaceTransitGatewayRouteRequest> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceTransitGatewayRouteRequest.getter(ReplaceTransitGatewayRouteRequest::destinationCidrBlock)).setter(ReplaceTransitGatewayRouteRequest.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("DestinationCidrBlock").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceTransitGatewayRouteRequest.getter(ReplaceTransitGatewayRouteRequest::transitGatewayRouteTableId)).setter(ReplaceTransitGatewayRouteRequest.setter(Builder::transitGatewayRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableId").unmarshallLocationName("TransitGatewayRouteTableId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplaceTransitGatewayRouteRequest.getter(ReplaceTransitGatewayRouteRequest::transitGatewayAttachmentId)).setter(ReplaceTransitGatewayRouteRequest.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("TransitGatewayAttachmentId").build()}).build();
    private static final SdkField<Boolean> BLACKHOLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ReplaceTransitGatewayRouteRequest.getter(ReplaceTransitGatewayRouteRequest::blackhole)).setter(ReplaceTransitGatewayRouteRequest.setter(Builder::blackhole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blackhole").unmarshallLocationName("Blackhole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD, TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD, TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, BLACKHOLE_FIELD));
    private final String destinationCidrBlock;
    private final String transitGatewayRouteTableId;
    private final String transitGatewayAttachmentId;
    private final Boolean blackhole;

    private ReplaceTransitGatewayRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.transitGatewayRouteTableId = builder.transitGatewayRouteTableId;
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.blackhole = builder.blackhole;
    }

    public String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public String transitGatewayRouteTableId() {
        return this.transitGatewayRouteTableId;
    }

    public String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public Boolean blackhole() {
        return this.blackhole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.blackhole());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceTransitGatewayRouteRequest)) {
            return false;
        }
        ReplaceTransitGatewayRouteRequest other = (ReplaceTransitGatewayRouteRequest)((Object)obj);
        return Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.transitGatewayRouteTableId(), other.transitGatewayRouteTableId()) && Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.blackhole(), other.blackhole());
    }

    public String toString() {
        return ToString.builder((String)"ReplaceTransitGatewayRouteRequest").add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("TransitGatewayRouteTableId", (Object)this.transitGatewayRouteTableId()).add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("Blackhole", (Object)this.blackhole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "TransitGatewayRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableId()));
            }
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "Blackhole": {
                return Optional.ofNullable(clazz.cast(this.blackhole()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplaceTransitGatewayRouteRequest, T> g) {
        return obj -> g.apply((ReplaceTransitGatewayRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private String transitGatewayRouteTableId;
        private String transitGatewayAttachmentId;
        private Boolean blackhole;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceTransitGatewayRouteRequest model) {
            super(model);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.transitGatewayRouteTableId(model.transitGatewayRouteTableId);
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.blackhole(model.blackhole);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getTransitGatewayRouteTableId() {
            return this.transitGatewayRouteTableId;
        }

        @Override
        public final Builder transitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
            return this;
        }

        public final void setTransitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        public final Boolean getBlackhole() {
            return this.blackhole;
        }

        @Override
        public final Builder blackhole(Boolean blackhole) {
            this.blackhole = blackhole;
            return this;
        }

        public final void setBlackhole(Boolean blackhole) {
            this.blackhole = blackhole;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplaceTransitGatewayRouteRequest build() {
            return new ReplaceTransitGatewayRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReplaceTransitGatewayRouteRequest> {
        public Builder destinationCidrBlock(String var1);

        public Builder transitGatewayRouteTableId(String var1);

        public Builder transitGatewayAttachmentId(String var1);

        public Builder blackhole(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

