/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInterfacePrivateIpAddress
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInterfacePrivateIpAddress> {
    private static final SdkField<NetworkInterfaceAssociation> ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(NetworkInterfacePrivateIpAddress.getter(NetworkInterfacePrivateIpAddress::association)).setter(NetworkInterfacePrivateIpAddress.setter(Builder::association)).constructor(NetworkInterfaceAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association").unmarshallLocationName("association").build()}).build();
    private static final SdkField<Boolean> PRIMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(NetworkInterfacePrivateIpAddress.getter(NetworkInterfacePrivateIpAddress::primary)).setter(NetworkInterfacePrivateIpAddress.setter(Builder::primary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").unmarshallLocationName("primary").build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkInterfacePrivateIpAddress.getter(NetworkInterfacePrivateIpAddress::privateDnsName)).setter(NetworkInterfacePrivateIpAddress.setter(Builder::privateDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName").unmarshallLocationName("privateDnsName").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkInterfacePrivateIpAddress.getter(NetworkInterfacePrivateIpAddress::privateIpAddress)).setter(NetworkInterfacePrivateIpAddress.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("privateIpAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD, PRIMARY_FIELD, PRIVATE_DNS_NAME_FIELD, PRIVATE_IP_ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final NetworkInterfaceAssociation association;
    private final Boolean primary;
    private final String privateDnsName;
    private final String privateIpAddress;

    private NetworkInterfacePrivateIpAddress(BuilderImpl builder) {
        this.association = builder.association;
        this.primary = builder.primary;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
    }

    public NetworkInterfaceAssociation association() {
        return this.association;
    }

    public Boolean primary() {
        return this.primary;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.association());
        hashCode = 31 * hashCode + Objects.hashCode(this.primary());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfacePrivateIpAddress)) {
            return false;
        }
        NetworkInterfacePrivateIpAddress other = (NetworkInterfacePrivateIpAddress)obj;
        return Objects.equals(this.association(), other.association()) && Objects.equals(this.primary(), other.primary()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress());
    }

    public String toString() {
        return ToString.builder((String)"NetworkInterfacePrivateIpAddress").add("Association", (Object)this.association()).add("Primary", (Object)this.primary()).add("PrivateDnsName", (Object)this.privateDnsName()).add("PrivateIpAddress", (Object)this.privateIpAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Association": {
                return Optional.ofNullable(clazz.cast(this.association()));
            }
            case "Primary": {
                return Optional.ofNullable(clazz.cast(this.primary()));
            }
            case "PrivateDnsName": {
                return Optional.ofNullable(clazz.cast(this.privateDnsName()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterfacePrivateIpAddress, T> g) {
        return obj -> g.apply((NetworkInterfacePrivateIpAddress)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NetworkInterfaceAssociation association;
        private Boolean primary;
        private String privateDnsName;
        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfacePrivateIpAddress model) {
            this.association(model.association);
            this.primary(model.primary);
            this.privateDnsName(model.privateDnsName);
            this.privateIpAddress(model.privateIpAddress);
        }

        public final NetworkInterfaceAssociation.Builder getAssociation() {
            return this.association != null ? this.association.toBuilder() : null;
        }

        @Override
        public final Builder association(NetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(NetworkInterfaceAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        public final Boolean getPrimary() {
            return this.primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public NetworkInterfacePrivateIpAddress build() {
            return new NetworkInterfacePrivateIpAddress(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInterfacePrivateIpAddress> {
        public Builder association(NetworkInterfaceAssociation var1);

        default public Builder association(Consumer<NetworkInterfaceAssociation.Builder> association) {
            return this.association((NetworkInterfaceAssociation)((NetworkInterfaceAssociation.Builder)NetworkInterfaceAssociation.builder().applyMutation(association)).build());
        }

        public Builder primary(Boolean var1);

        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);
    }
}

