/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.awstxstore;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.ziniki.awstxstore.DynamoHelper;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.utils.FileUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class GrabLoginToken {
    public static void main(String[] argv) throws JSONException {
        String home = System.getProperty("user.home");
        if (home == null) {
            throw new InvalidUsageException("no home directory");
        }
        File f = new File(home, ".zintok");
        if (argv.length != 1) {
            throw new InvalidUsageException("Specify a table prefix");
        }
        String prefix = argv[0];
        String table = prefix + "Entities";
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.create();
        DynamoDbClient db = (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).region(Region.US_EAST_1)).build();
        TreeMap<String, String> names = new TreeMap<String, String>();
        names.put("#key", "_key");
        TreeMap<String, AttributeValue> map = new TreeMap<String, AttributeValue>();
        DynamoHelper.put(map, ":pfx", "security://ziniki.org/token/");
        ScanRequest query = (ScanRequest)ScanRequest.builder().tableName(table).filterExpression("begins_with(#key, :pfx)").expressionAttributeNames(names).expressionAttributeValues(map).build();
        ScanResponse r = db.scan(query);
        if (!r.hasItems() || r.items().isEmpty()) {
            throw new InvalidUsageException("there were no tokens");
        }
        Map tok = (Map)r.items().get(0);
        String token = DynamoHelper.string(tok, "token");
        String secret = DynamoHelper.string(tok, "secret");
        JSONObject jo = new JSONObject();
        jo.put("token", (Object)token);
        jo.put("secret", (Object)secret);
        try {
            FileUtils.writeFile((File)f, (String)jo.toString());
            System.out.println("Written " + jo + " to " + f);
        }
        catch (Exception ex) {
            throw new InvalidUsageException("could not create ~/.zintok: " + ex);
        }
    }
}

