/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.awstxstore;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.awstxstore.DynamoHelper;
import org.ziniki.tdastore.ZiidRangeConsumer;
import org.ziniki.tdastore.ZiidRangeProvider;
import org.ziniki.ziwsh.intf.Param;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;

public class DynamoZiidProvider
implements ZiidRangeProvider {
    public static final Logger logger = LoggerFactory.getLogger((String)"DynamoZiids");
    private final String table;
    private final Executor exec;
    private final Long rangeSize;
    private final DynamoDbClient db;
    private Supplier<Runnable> faultInjector;

    public DynamoZiidProvider(@Param(value="table") String table, @Param(value="exec") Executor exec, @Param(value="rangeSize") long rangeSize) {
        this.table = table + "Ziids";
        this.exec = exec;
        this.rangeSize = rangeSize;
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.create();
        this.db = (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).region(Region.US_EAST_1)).build();
    }

    public void provideRange(ZiidRangeConsumer consumer, String scheme, String type) {
        this.exec.execute(() -> this.doScan(consumer, scheme, type));
    }

    private void doScan(ZiidRangeConsumer consumer, String scheme, String type) {
        Runnable later = null;
        while (true) {
            GetItemResponse item = this.db.getItem(DynamoHelper.key(this.table, "scheme", scheme, "type", type));
            try {
                String cond;
                Long issued;
                String prefix;
                TreeMap<String, AttributeValue> curr = null;
                TreeMap<String, AttributeValue> updated = new TreeMap<String, AttributeValue>();
                if (!item.hasItem()) {
                    prefix = "aa";
                    issued = 0L;
                    cond = "attribute_not_exists(issued)";
                } else {
                    Map map = item.item();
                    prefix = DynamoHelper.string(map, "prefix");
                    issued = DynamoHelper.longValue(map, "issued");
                    cond = "issued = :curr";
                    curr = new TreeMap<String, AttributeValue>();
                    DynamoHelper.put(curr, ":curr", issued);
                }
                logger.info("hitting FI with " + issued);
                if (this.faultInjector != null && later == null) {
                    later = this.faultInjector.get();
                }
                logger.info("after FI with " + later);
                Long next = issued + this.rangeSize;
                DynamoHelper.put(updated, "_scheme", scheme);
                DynamoHelper.put(updated, "_type", type);
                DynamoHelper.put(updated, "prefix", prefix);
                DynamoHelper.put(updated, "issued", next);
                PutItemRequest.Builder pir = DynamoHelper.putItem(this.table, updated);
                pir.conditionExpression(cond);
                pir.expressionAttributeValues(curr);
                this.db.putItem((PutItemRequest)pir.build());
                logger.info("putting " + prefix + " " + next);
                if (later != null) {
                    later.run();
                }
                logger.info("delivering " + prefix + " " + next);
                consumer.range(prefix, issued + 1L, next.longValue());
            }
            catch (ConditionalCheckFailedException ex) {
                logger.info("update failed so trying again", (Throwable)ex);
                continue;
            }
            break;
        }
    }

    public void inject(Supplier<Runnable> injection) {
        this.faultInjector = injection;
    }
}

