/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.awstxstore;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.awstxstore.DynamoCollector;
import org.ziniki.awstxstore.DynamoFieldsMarshaller;
import org.ziniki.awstxstore.DynamoHelper;
import org.ziniki.awstxstore.DynamoListMarshaller;
import org.ziniki.awstxstore.DynamoMapMarshaller;
import org.ziniki.ziwsh.intf.CollectionState;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.FieldsMarshaller;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.MarshallingTraverser;
import org.ziniki.ziwsh.intf.ObjectMarshalling;
import org.ziniki.ziwsh.intf.Wireable;
import org.zinutils.exceptions.NotImplementedException;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public abstract class DynamoMarshaller
implements MarshallingTraverser,
DynamoCollector {
    public static final Logger logger = LoggerFactory.getLogger((String)"awstxstore");

    public CollectionState state() {
        return null;
    }

    public void key(String key) {
        throw new NotImplementedException("only in map marshaller");
    }

    public void integer(Integer n) {
        this.collect(n);
    }

    public void longint(Long l) {
        this.collect(l);
    }

    public void string(String s) {
        this.collect(s);
    }

    public void uri(URI uri) {
        this.collect(uri);
    }

    public void bool(Boolean b) {
        this.collect(b);
    }

    public void real(Double d) {
        this.collect(d);
    }

    public void date(Date d) {
        this.collect(d);
    }

    public void wireable(EvalContext cx, ObjectMarshalling om, Wireable w) {
        try {
            Map fields = w.fields();
            logger.info("wireable serialized as " + fields);
            TreeMap<String, AttributeValue> nested = new TreeMap<String, AttributeValue>();
            DynamoHelper.put(nested, "_clz", "_wireable");
            DynamoHelper.put(nested, "_wireable", w.getClass().getName());
            for (Map.Entry e : fields.entrySet()) {
                DynamoHelper.put(nested, (String)e.getKey(), e.getValue());
            }
            this.collect(nested);
        }
        catch (IOException e) {
            logger.error("error encoding wireable", (Throwable)e);
        }
    }

    public boolean handleCycle(Object o) {
        return false;
    }

    public void circle(Object o, Object as) {
    }

    public FieldsMarshaller beginFields(Class<? extends FieldsContainerWrapper> clz) {
        return new DynamoFieldsMarshaller(this, clz);
    }

    public MarshallingTraverser beginList() {
        return new DynamoListMarshaller(this);
    }

    public MarshallingTraverser beginMap() {
        return new DynamoMapMarshaller(this);
    }

    public Object collectingAs() {
        return null;
    }

    public void unpack(Object collectingAs) {
        throw new NotImplementedException();
    }

    public void handler(IdempotentHandler handler) {
        throw new NotImplementedException();
    }

    public void complete() {
    }
}

