/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.awstxstore;

import java.util.Map;
import java.util.TreeMap;
import org.ziniki.awstxstore.DynamoHelper;
import org.ziniki.awstxstore.DynamoMarshaller;
import org.ziniki.ziwsh.intf.MarshallingTraverser;
import org.zinutils.exceptions.CantHappenException;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class DynamoMapMarshaller
extends DynamoMarshaller
implements MarshallingTraverser {
    private final DynamoMarshaller parent;
    private final Map<String, AttributeValue> map = new TreeMap<String, AttributeValue>();
    private String field;

    public DynamoMapMarshaller(DynamoMarshaller parent) {
        this.parent = parent;
    }

    @Override
    public void key(String key) {
        if (this.field != null) {
            throw new CantHappenException("field is not null");
        }
        this.field = key;
    }

    @Override
    public void collect(Object obj) {
        if (this.field == null) {
            throw new CantHappenException("field is null");
        }
        DynamoHelper.put(this.map, this.field, obj);
        this.field = null;
    }

    @Override
    public void complete() {
        if (!this.map.isEmpty()) {
            this.parent.collect(this.map);
        }
    }
}

