/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.awstxstore;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ziniki.awstxstore.AWSTxStorageOptions;
import org.ziniki.awstxstore.DynamoTopLevelMarshaller;
import org.ziniki.tdastore.StorageOptions;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.MarshallingTraverser;
import org.ziniki.ziwsh.jvm.ObjectMarshaller;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.NotImplementedException;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

public class DynamoHelper {
    public static final DynamoTableDefn[] dynamoTables = new DynamoTableDefn[]{new DynamoTableDefn("Entities", "_key", null), new DynamoTableDefn("Subscriptions", "_watch", "_subscriber"), new DynamoTableDefn("Crobags", "_id", "_idx"), new DynamoTableDefn("IdentityBench", "identity", "bench"), new DynamoTableDefn("EntityBench", "entity", "bench"), new DynamoTableDefn("SecondaryInArena", "catalogue", "arena"), new DynamoTableDefn("Ziids", "_scheme", "_type")};

    public static GetItemRequest key(String table, String key, String id, String ... range) {
        TreeMap<CallSite, AttributeValue> map = new TreeMap<CallSite, AttributeValue>();
        map.put((CallSite)((Object)("_" + key)), (AttributeValue)AttributeValue.builder().s(id).build());
        if (range.length != 0) {
            if (range.length != 2) {
                throw new InvalidUsageException("need 2 args here");
            }
            map.put((CallSite)((Object)("_" + range[0])), (AttributeValue)AttributeValue.builder().s(range[1]).build());
        }
        return (GetItemRequest)GetItemRequest.builder().tableName(table).key(map).build();
    }

    public static String string(Map<String, AttributeValue> item, String fld) {
        if (!item.containsKey(fld)) {
            return null;
        }
        AttributeValue v = item.get(fld);
        return v.s();
    }

    public static Long longValue(Map<String, AttributeValue> item, String fld) {
        if (!item.containsKey(fld)) {
            return null;
        }
        AttributeValue v = item.get(fld);
        return Long.parseLong(v.n());
    }

    public static PutItemRequest.Builder putThing(EvalContext cx, String table, String id, long version, Object obj, StorageOptions options) throws ClassNotFoundException {
        TreeMap<String, AttributeValue> map = new TreeMap<String, AttributeValue>();
        if (options != null) {
            ((AWSTxStorageOptions)options).applyTo(map, "_");
        }
        if (obj != null) {
            DynamoHelper.marshalToMap(cx, map, obj);
        }
        map.put("_key", (AttributeValue)AttributeValue.builder().s(id).build());
        map.put("_version", (AttributeValue)AttributeValue.builder().n(Long.toString(version)).build());
        return DynamoHelper.putItem(table, map);
    }

    public static PutItemRequest.Builder putItem(String table, Map<String, AttributeValue> map) {
        return PutItemRequest.builder().tableName(table).item(map);
    }

    public static void marshalToMap(EvalContext cx, Map<String, AttributeValue> map, Object obj) throws ClassNotFoundException {
        DynamoTopLevelMarshaller dfm = new DynamoTopLevelMarshaller();
        ObjectMarshaller om = new ObjectMarshaller((MarshallingTraverser)dfm, true);
        om.marshal(cx, obj);
        dfm.complete();
        dfm.store(map);
    }

    public static DeleteItemRequest deleteThing(String table, String keyfld, String key, String ... range) {
        TreeMap<CallSite, AttributeValue> dmap = new TreeMap<CallSite, AttributeValue>();
        dmap.put((CallSite)((Object)("_" + keyfld)), (AttributeValue)AttributeValue.builder().s(key).build());
        if (range.length != 0) {
            if (range.length != 2) {
                throw new InvalidUsageException("need 2 args here");
            }
            dmap.put((CallSite)((Object)("_" + range[0])), (AttributeValue)AttributeValue.builder().s(range[1]).build());
        }
        DeleteItemRequest.Builder dir = DeleteItemRequest.builder();
        if (table != null) {
            dir.tableName(table);
        }
        dir.key(dmap);
        return (DeleteItemRequest)dir.build();
    }

    public static void put(Map<String, AttributeValue> map, String key, Object val) {
        AttributeValue tmp = DynamoHelper.attr(val);
        if (tmp != null) {
            map.put(key, tmp);
        }
    }

    public static AttributeValue attr(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof AttributeValue) {
            return (AttributeValue)val;
        }
        if (val instanceof String) {
            return (AttributeValue)AttributeValue.builder().s((String)val).build();
        }
        if (val instanceof Date) {
            TreeMap<String, AttributeValue> nested = new TreeMap<String, AttributeValue>();
            DynamoHelper.put(nested, "_clz", "_javaDate");
            DynamoHelper.put(nested, "unixtime", ((Date)val).getTime() / 1000L);
            return (AttributeValue)AttributeValue.builder().m(nested).build();
        }
        if (val instanceof Integer) {
            return (AttributeValue)AttributeValue.builder().n(Integer.toString((Integer)val)).build();
        }
        if (val instanceof Boolean) {
            return (AttributeValue)AttributeValue.builder().bool((Boolean)val).build();
        }
        if (val instanceof Long) {
            return (AttributeValue)AttributeValue.builder().n(Long.toString((Long)val)).build();
        }
        if (val instanceof Double) {
            return (AttributeValue)AttributeValue.builder().n(Double.toString((Double)val)).build();
        }
        if (val instanceof Collection) {
            return (AttributeValue)AttributeValue.builder().l((Collection)val).build();
        }
        if (val instanceof Map) {
            return (AttributeValue)AttributeValue.builder().m((Map)val).build();
        }
        throw new NotImplementedException(val.getClass().toString());
    }

    public static Object extract(AttributeValue attr) {
        if (attr.s() != null) {
            return attr.s();
        }
        if (attr.n() != null) {
            return Double.parseDouble(attr.n());
        }
        if (attr.bool() != null) {
            return attr.bool();
        }
        throw new NotImplementedException();
    }

    public static BatchWriteItemRequest deleteMany(String table, String scanKey, String rangeKey, List<Map<String, AttributeValue>> items) {
        BatchWriteItemRequest.Builder bir = BatchWriteItemRequest.builder();
        ArrayList<WriteRequest> deletes = new ArrayList<WriteRequest>();
        for (Map<String, AttributeValue> i : items) {
            TreeMap<String, AttributeValue> map = new TreeMap<String, AttributeValue>();
            map.put(scanKey, i.get(scanKey));
            if (rangeKey != null) {
                map.put(rangeKey, i.get(rangeKey));
            }
            deletes.add((WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key(map).build()).build());
            if (deletes.size() < 25) continue;
            break;
        }
        TreeMap<String, ArrayList<WriteRequest>> deleteFromTable = new TreeMap<String, ArrayList<WriteRequest>>();
        deleteFromTable.put(table, deletes);
        return (BatchWriteItemRequest)bir.requestItems(deleteFromTable).build();
    }

    public static class DynamoTableDefn {
        public final String table;
        public final String key;
        public final String range;

        public DynamoTableDefn(String table, String key, String range) {
            this.table = table;
            this.key = key;
            this.range = range;
        }
    }
}

