/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.Beachhead;
import org.ziniki.ziwsh.intf.EntryId;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.JsonSender;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.intf.WebSocketFinder;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.JsonBeachhead;

public class TestWebSocketFinder
implements WebSocketFinder {
    private static final Logger logger = LoggerFactory.getLogger((String)"ZinikiTI");
    private final Map<String, ResponderEntry> wss = new TreeMap<String, ResponderEntry>();
    private final ZiwshBroker ziwshBroker;
    private final ClassLoader classLoader;

    public TestWebSocketFinder(ZiwshBroker ziwshBroker, ClassLoader classLoader) {
        logger.info("Creating new TestWebSocketFinder");
        this.ziwshBroker = ziwshBroker;
        this.classLoader = classLoader;
    }

    public void remember(EvalContext cx, String tok, EntryId mytok, String secret, WSResponder responder) {
        JsonBeachhead srvBeach = new JsonBeachhead((WebSocketFinder)this, this.ziwshBroker.creator(), tok, (JsonSender)responder, this.ziwshBroker, null, this.classLoader);
        this.ziwshBroker.clientBeachhead(tok, (Beachhead)srvBeach);
        this.wss.put(tok, new ResponderEntry(tok, responder, srvBeach));
        logger.info("remembered " + tok + " in " + this.wss + " in " + this);
    }

    public WebSocketFinder.Entry find(String tok, EntryId _tok) {
        ResponderEntry ret = this.wss.get(tok);
        if (ret == null) {
            logger.error("There is no responder entry for " + tok + " in " + this.wss + " in " + this);
        }
        return ret;
    }

    public class ResponderEntry
    implements WebSocketFinder.Entry {
        private final WSResponder responder;
        private final JsonBeachhead srvBeach;
        private final String tok;

        public ResponderEntry(String tok, WSResponder responder, JsonBeachhead srvBeach) {
            this.responder = responder;
            this.tok = tok;
            this.srvBeach = srvBeach;
        }

        public WSResponder responder() {
            return this.responder;
        }

        public void dispatch(EvalContext cx, String text) {
            this.srvBeach.dispatch(cx, text, this.responder);
        }

        public Beachhead beachhead() {
            return this.srvBeach;
        }

        public String toString() {
            return "Responder[" + this.tok + "]";
        }
    }
}

