/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.flasck.flas.blockForm.ContinuedLine;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.BlockConsumer;
import org.flasck.flas.blocker.Blocker;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.errors.ErrorResult;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.NumberToken;
import org.flasck.flas.tokenizers.StringToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;
import org.flasck.jvm.FLEvalContext;
import org.ziniki.DomainKey;
import org.ziniki.common.ZiIdURI;
import org.ziniki.core.fl.EntityOnBench;
import org.ziniki.core.fl.JVMArena;
import org.ziniki.core.fl.JVMBench;
import org.ziniki.core.fl.JVMSecondaryKeyEntry;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.storage.memory.IMStorage;
import org.ziniki.storage.memory.LinkThing;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.CollectionState;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.MarshallingTraverser;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.CollectingState;
import org.ziniki.ziwsh.jvm.JsonExtractor;
import org.ziniki.ziwsh.jvm.JsonFieldsMarshaller;
import org.ziniki.ziwsh.jvm.ListTraverser;
import org.ziniki.ziwsh.jvm.ObjectMarshaller;
import org.zinutils.collections.ListMap;
import org.zinutils.collections.MapMap;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.utils.FileUtils;

public class IMLoader {
    private final JsonFactory jf = new JsonFactory();
    private final Map<String, IMStorage.DictEntry> dict;
    private final MapMap<String, String, File> mys;
    private final ListMap<String, LinkThing> links;
    private final ZiwshBroker broker;
    private final ClassLoader loader;

    public IMLoader(ZiwshBroker broker, ClassLoader loader, Map<String, IMStorage.DictEntry> dict, MapMap<String, String, File> mys, ListMap<String, LinkThing> links) {
        this.broker = broker;
        this.loader = loader;
        this.dict = dict;
        this.mys = mys;
        this.links = links;
    }

    public void loadFrom(File datadir) {
        List dfs = FileUtils.findFilesUnderMatching((File)datadir, (String)"*");
        block10: for (File f : dfs) {
            File path = new File(datadir, f.getPath());
            String ext = FileUtils.extension((String)f.getName());
            if (ext == null && f.getName().equals("domain") || !path.isFile()) continue;
            List parts = FileUtils.pathElements((File)f);
            String serverName = (String)parts.get(0);
            switch (ext) {
                case ".my": {
                    String name = FileUtils.dropExtension((String)((String)parts.get(2)));
                    String key = "my://" + serverName + "/" + name;
                    this.mys.add((Object)((String)parts.get(1)), (Object)key, (Object)path);
                    continue block10;
                }
                case ".en": {
                    String name = FileUtils.dropExtension((String)((String)parts.get(1)));
                    String key = "data://" + serverName + "/entity/" + name;
                    this.dict.put(key, new IMStorage.DictEntry(this.readObject(path)));
                    continue block10;
                }
                case ".ar": {
                    String name = FileUtils.dropExtension((String)((String)parts.get(1)));
                    String key = "data://" + serverName + "/arena/" + name;
                    this.dict.put(key, new IMStorage.DictEntry(this.readArena(key, path)));
                    continue block10;
                }
            }
            throw new HaventConsideredThisException("No extension " + ext + " for " + f);
        }
    }

    public void configureDomain(final ZiIdFactory ziidFactory, final UnitOfWork uow, final String domain, File domainFile) throws JSONException {
        final ZiIdURI did = (ZiIdURI)ziidFactory.unique("ziniki", domain, "domain");
        final JSONObject domObj = new JSONObject(this.dict.get((Object)did.toString()).json);
        final ErrorResult errors = new ErrorResult();
        System.out.println("domObj = " + domObj);
        Blocker blocker = new Blocker((ErrorReporter)errors, new BlockConsumer(){
            JSONArray benches;
            JSONObject currBench;
            {
                this.benches = domObj.getJSONArray("_benches");
                this.currBench = null;
            }

            public void newFile() {
            }

            public void line(int depth, ContinuedLine currline) {
                block26: {
                    Tokenizable tw = new Tokenizable(currline);
                    try {
                        block1 : switch (depth) {
                            case 1: {
                                KeywordToken kw = KeywordToken.from((ErrorReporter)errors, (Tokenizable)tw);
                                if (kw == null) {
                                    errors.message(tw, "no keyword in " + tw);
                                    break;
                                }
                                switch (kw.text) {
                                    case "bench": {
                                        String bench = StringToken.from((ErrorReporter)errors, (Tokenizable)tw);
                                        if (bench == null) {
                                            errors.message(tw, "no string in " + tw);
                                            break;
                                        }
                                        this.currBench = null;
                                        for (int i = 0; i < this.benches.length(); ++i) {
                                            JSONObject b = this.benches.getJSONObject(i);
                                            if (!b.getString("name").equals(bench)) continue;
                                            this.currBench = b;
                                            break;
                                        }
                                        if (this.currBench == null) {
                                            ZiIdURI bid = did.makeType("bench").append(bench);
                                            this.currBench = new JSONObject();
                                            this.currBench.put("_clz", (Object)JVMBench.class.getName());
                                            this.currBench.put("_id", (Object)bid.toString());
                                            this.currBench.put("name", (Object)bench);
                                            this.benches.put((Object)this.currBench);
                                            break;
                                        }
                                        break block26;
                                    }
                                    default: {
                                        errors.message(tw, "unknown command: " + kw);
                                        break;
                                    }
                                }
                                break;
                            }
                            case 2: {
                                KeywordToken kw = KeywordToken.from((ErrorReporter)errors, (Tokenizable)tw);
                                if (kw == null) {
                                    errors.message(tw, "no keyword in " + tw);
                                    break;
                                }
                                switch (kw.text) {
                                    case "entity": {
                                        InputPosition pos = tw.realinfo();
                                        String eid = StringToken.from((ErrorReporter)errors, (Tokenizable)tw);
                                        if (eid == null) {
                                            errors.message(tw, "no entity name in " + tw);
                                            break block1;
                                        }
                                        ZiId eurl = ziidFactory.simple("data", domain, "entity", eid);
                                        if (!IMLoader.this.dict.containsKey(eurl.toString())) {
                                            errors.message(pos, "there is no entity '" + eid + "'");
                                            break block1;
                                        }
                                        String refclz = new JSONObject(IMLoader.this.dict.get((Object)eurl.toString()).json).getString("_clz");
                                        EntityOnBench eb = new EntityOnBench((ZiId)ZiIdURI.fromString((String)((String)this.currBench.get("_id"))), eurl, (ZiId)did);
                                        IMLoader.this.links.add((Object)eb.table(), (Object)new LinkThing(eb.table(), eb.hash(), eb.range(), IMLoader.this.flatten((EvalContext)uow, eb)));
                                        String sk = did.makeScheme("seckey").append(DomainKey.class.getName()).append(refclz).toString();
                                        if (IMLoader.this.dict.containsKey(sk)) {
                                            errors.message(pos, "duplicate entry in DomainKey for " + refclz + " in " + domain);
                                            break block1;
                                        }
                                        JVMSecondaryKeyEntry pt = new JVMSecondaryKeyEntry((FLEvalContext)uow, eurl.toString());
                                        pt.set("_id", (Object)sk);
                                        IMLoader.this.dict.put(sk, new IMStorage.DictEntry(IMLoader.this.flatten((EvalContext)uow, pt)));
                                        break block1;
                                    }
                                }
                                errors.message(tw, "unknown command: " + kw);
                                break;
                            }
                            default: {
                                throw new HaventConsideredThisException("not handled " + currline + " for depth " + depth);
                            }
                        }
                    }
                    catch (IOException | ClassNotFoundException | JSONException ex) {
                        errors.message(tw, ex.toString());
                    }
                }
            }

            public void flush() {
            }

            public void comment(InputPosition pos, String text) {
            }
        });
        List lines = FileUtils.readFileAsLines((File)domainFile);
        int ln = 1;
        for (String s : lines) {
            blocker.present(domainFile.getName(), ln++, s);
        }
        blocker.flush();
        if (errors.hasErrors()) {
            try {
                throw new InvalidUsageException(errors.singleString());
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Throwable)ex);
            }
        }
    }

    public String readObject(File path) {
        final JSONObject jo = new JSONObject();
        try {
            jo.put("_security", (Object)new JSONObject());
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
        final ErrorResult errors = new ErrorResult();
        Blocker blocker = new Blocker((ErrorReporter)errors, new BlockConsumer(){

            public void newFile() {
            }

            public void line(int depth, ContinuedLine currline) {
                Tokenizable tw = new Tokenizable(currline);
                try {
                    block1 : switch (depth) {
                        case 1: {
                            KeywordToken kw = KeywordToken.from((ErrorReporter)errors, (Tokenizable)tw);
                            if (kw == null) {
                                errors.message(tw, "no keyword in " + tw);
                                break;
                            }
                            switch (kw.text) {
                                case "type": {
                                    TypeNameToken st = TypeNameToken.qualified((ErrorReporter)errors, (Tokenizable)tw);
                                    if (st == null) {
                                        errors.message(tw, "type must have a string");
                                        break block1;
                                    }
                                    if (tw.hasMoreContent((ErrorReporter)errors)) {
                                        errors.message(tw, "garbage at end of line");
                                        break block1;
                                    }
                                    jo.put("_clz", (Object)st.text);
                                    jo.put("type", (Object)st.text);
                                    break block1;
                                }
                            }
                            errors.message(tw, "unknown command");
                            break;
                        }
                        case 2: {
                            KeywordToken kw = KeywordToken.from((ErrorReporter)errors, (Tokenizable)tw);
                            if (kw == null) {
                                errors.message(tw, "no keyword in " + tw);
                                break;
                            }
                            String fld = StringToken.from((ErrorReporter)errors, (Tokenizable)tw);
                            if (fld == null) {
                                errors.message(tw, "no field in " + tw);
                                break;
                            }
                            switch (kw.text) {
                                case "string": {
                                    String s = StringToken.from((ErrorReporter)errors, (Tokenizable)tw);
                                    if (s == null) {
                                        errors.message(tw, "no string in " + tw);
                                        break block1;
                                    }
                                    jo.put(fld, (Object)s);
                                    break block1;
                                }
                                case "number": {
                                    NumberToken nt = NumberToken.from((ErrorReporter)errors, (Tokenizable)tw);
                                    if (nt == null) {
                                        errors.message(tw, "no number in " + tw);
                                        break block1;
                                    }
                                    jo.put(fld, Double.parseDouble(nt.text));
                                    break block1;
                                }
                            }
                            errors.message(tw, "unknown command");
                            break;
                        }
                        default: {
                            throw new HaventConsideredThisException("not handled " + currline + " for depth " + depth);
                        }
                    }
                }
                catch (JSONException ex) {
                    errors.message(tw, ex.toString());
                }
            }

            public void flush() {
            }

            public void comment(InputPosition pos, String text) {
            }
        });
        List lines = FileUtils.readFileAsLines((File)path);
        int ln = 1;
        for (String s : lines) {
            blocker.present(path.getName(), ln++, s);
        }
        blocker.flush();
        if (errors.hasErrors()) {
            try {
                throw new InvalidUsageException(errors.singleString());
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Throwable)ex);
            }
        }
        return jo.toString();
    }

    public String readArena(String id, File path) {
        final ZiIdURI aid = ZiIdURI.fromString((String)id);
        final JSONObject jo = new JSONObject();
        final ErrorResult errors = new ErrorResult();
        Blocker blocker = new Blocker((ErrorReporter)errors, new BlockConsumer(){
            JSONArray benches = null;
            JSONObject currBench = null;

            public void newFile() {
            }

            public void line(int depth, ContinuedLine currline) {
                Tokenizable tw = new Tokenizable(currline);
                try {
                    block1 : switch (depth) {
                        case 1: {
                            KeywordToken kw = KeywordToken.from((ErrorReporter)errors, (Tokenizable)tw);
                            if (kw == null) {
                                errors.message(tw, "no keyword in " + tw);
                                break;
                            }
                            switch (kw.text) {
                                case "arena": {
                                    TypeNameToken st = TypeNameToken.qualified((ErrorReporter)errors, (Tokenizable)tw);
                                    if (st == null) {
                                        errors.message(tw, "arena must have a projection type name");
                                        break block1;
                                    }
                                    if (tw.hasMoreContent((ErrorReporter)errors)) {
                                        errors.message(tw, "garbage at end of line");
                                        break block1;
                                    }
                                    this.benches = new JSONArray();
                                    this.currBench = null;
                                    jo.put("_clz", (Object)JVMArena.class.getName());
                                    jo.put("_projection", (Object)st.text);
                                    jo.put("_benches", (Object)this.benches);
                                    break block1;
                                }
                            }
                            errors.message(tw, "unknown command");
                            break;
                        }
                        case 2: {
                            KeywordToken kw = KeywordToken.from((ErrorReporter)errors, (Tokenizable)tw);
                            if (kw == null) {
                                errors.message(tw, "no keyword in " + tw);
                                break;
                            }
                            switch (kw.text) {
                                case "bench": {
                                    String bench = StringToken.from((ErrorReporter)errors, (Tokenizable)tw);
                                    if (bench == null) {
                                        errors.message(tw, "no string in " + tw);
                                        break block1;
                                    }
                                    ZiIdURI bid = aid.makeType("bench").append(bench);
                                    this.currBench = new JSONObject();
                                    this.currBench.put("_clz", (Object)JVMBench.class.getName());
                                    this.currBench.put("_id", (Object)bid.toString());
                                    this.currBench.put("name", (Object)bench);
                                    this.benches.put((Object)this.currBench);
                                    break block1;
                                }
                            }
                            errors.message(tw, "unknown command: " + kw);
                            break;
                        }
                        default: {
                            throw new HaventConsideredThisException("not handled " + currline + " for depth " + depth);
                        }
                    }
                }
                catch (JSONException ex) {
                    errors.message(tw, ex.toString());
                }
            }

            public void flush() {
            }

            public void comment(InputPosition pos, String text) {
            }
        });
        List lines = FileUtils.readFileAsLines((File)path);
        int ln = 1;
        for (String s : lines) {
            blocker.present(path.getName(), ln++, s);
        }
        blocker.flush();
        if (errors.hasErrors()) {
            try {
                throw new InvalidUsageException(errors.singleString());
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Throwable)ex);
            }
        }
        return jo.toString();
    }

    public String flatten(EvalContext cx, Object obj) throws IOException, ClassNotFoundException {
        StringWriter sw = new StringWriter();
        JsonGenerator gen = this.jf.createGenerator((Writer)sw);
        JsonFieldsMarshaller fm = new JsonFieldsMarshaller(gen, this.broker, (CollectionState)new CollectingState());
        ObjectMarshaller om = new ObjectMarshaller((MarshallingTraverser)fm, true);
        om.marshal(cx, obj);
        gen.close();
        return sw.toString();
    }

    public Object inflate(EvalContext uow, String json) throws IOException, JsonParseException, ClassNotFoundException {
        IMStorage.logger.info("Trying to inflate " + json);
        JsonParser jp = this.jf.createParser(json);
        switch (jp.nextToken()) {
            case START_OBJECT: {
                Map flds = JsonExtractor.readObject((JsonParser)jp);
                ListTraverser trav = new ListTraverser(uow, (CollectionState)new CollectingState());
                JsonExtractor extractor = new JsonExtractor(this.loader, true);
                extractor.unmarshal(uow, (MarshallingTraverser)trav, (Object)flds);
                return trav.asList().get(0);
            }
            case START_ARRAY: {
                List readList = JsonExtractor.readList((JsonParser)jp);
                ListTraverser trav = new ListTraverser(uow, (CollectionState)new CollectingState());
                JsonExtractor extractor = new JsonExtractor(this.loader, true);
                extractor.unmarshal(uow, (MarshallingTraverser)trav, (Object)readList);
                return trav.asList();
            }
        }
        throw new NotImplementedException("cannot handle reading json: " + json);
    }
}

