/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.ziniki.ContentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.coreimpl.ZinikiClassLoader;
import org.ziniki.paas.interfaces.ContentStorage;
import org.ziniki.paas.interfaces.UploadContent;
import org.ziniki.storage.memory.IMCSObject;
import org.ziniki.storage.memory.IMUpload;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.utils.FileUtils;
import org.zinutils.utils.ZUJarEntry;
import org.zinutils.utils.ZUJarFile;

public class IMContentStorage
implements ContentStorage {
    public static final Logger logger = LoggerFactory.getLogger((String)"ZinikiTI");
    private final Map<String, IMCSObject> contents = new TreeMap<String, IMCSObject>();
    private final URI baseUri;

    public IMContentStorage(@Param(value="baseUri") String baseUri, @Param(value="load") JSONArray loaders) {
        File f;
        this.baseUri = URI.create(baseUri);
        String reload = System.getProperty("org.ziniki.memory.zip");
        if (reload != null && (f = new File(reload)).isFile()) {
            this.loadFromZip(f);
            return;
        }
        for (int i = 0; i < loaders.length(); ++i) {
            try {
                JSONObject jo = loaders.getJSONObject(i);
                File from = new File(jo.getString("from"));
                String pfx = jo.getString("prefix");
                String ct = null;
                if (jo.has("type")) {
                    ct = jo.getString("type");
                }
                for (File f2 : FileUtils.findFilesUnderMatching((File)from, (String)"*")) {
                    if (f2.getName().contains("_ut_") || f2.getName().contains("_st_")) continue;
                    String key = pfx + f2.toString();
                    this.contents.put(key, new IMCSObject(this, key, ct, FileUtils.readFileAsBytes((File)FileUtils.combine((File)from, (File)f2))));
                }
                continue;
            }
            catch (Exception ex) {
                logger.error("Could not handle item " + i);
            }
        }
    }

    public void provideLoader(ZinikiClassLoader zcl) {
    }

    public List<ContentObject> matching(String prefix, String pattern) {
        Pattern p = Pattern.compile(pattern);
        ArrayList<ContentObject> ret = new ArrayList<ContentObject>();
        for (IMCSObject co : this.contents.values()) {
            if (!co.key().startsWith(prefix) || p.matcher(co.key()).find()) {
                // empty if block
            }
            ret.add(co);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMCSObject get(String key) {
        logger.info("requested item " + key);
        Map<String, IMCSObject> map = this.contents;
        synchronized (map) {
            IMCSObject ret = this.contents.get(key);
            System.out.println("returning item " + ret);
            return ret;
        }
    }

    public ContentObject newObject(FLEvalContext cx, String name, String contentType) {
        return new IMCSObject(this, "created/" + UUID.randomUUID() + "/" + name, contentType, null);
    }

    public ContentObject objectPath(FLEvalContext cx, String path, String contentType) {
        return new IMCSObject(this, path, contentType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentObject upload(String key, File f, String contentType) {
        IMCSObject co = new IMCSObject(this, key, contentType, FileUtils.readFileAsBytes((File)f));
        Map<String, IMCSObject> map = this.contents;
        synchronized (map) {
            this.contents.put(key, co);
            return co;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentObject upload(String key, InputStream is, String contentType, long length, boolean closeInput) throws IOException {
        IMCSObject co = new IMCSObject(this, key, contentType, FileUtils.readOffsetStream((InputStream)is, (int)0, (int)((int)length)));
        Map<String, IMCSObject> map = this.contents;
        synchronized (map) {
            this.contents.put(key, co);
            return co;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentObject store(String key, byte[] byteArray, String contentType) {
        IMCSObject co = new IMCSObject(this, key, contentType, byteArray);
        Map<String, IMCSObject> map = this.contents;
        synchronized (map) {
            this.contents.put(key, co);
            return co;
        }
    }

    public UploadContent upload(String key, String contentType) throws IOException {
        return new IMUpload(this, key, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> allKeys() {
        Map<String, IMCSObject> map = this.contents;
        synchronized (map) {
            return new TreeSet<String>(this.contents.keySet());
        }
    }

    public URI url(String key) {
        return this.baseUri.resolve(key);
    }

    public URI writeUrl(String key) {
        return this.baseUri.resolve(key);
    }

    private void loadFromZip(File f) {
        logger.info("Loading ContentStorage from " + f);
        ZUJarFile jf = new ZUJarFile(f);
        TreeMap<String, String> cts = new TreeMap<String, String>();
        for (ZUJarEntry p : jf) {
            String name;
            if (p.getName().startsWith("ct/")) {
                name = p.getName().substring(p.getName().indexOf(47) + 1);
                try {
                    cts.put(name, new String(p.getBytes(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    logger.error("  failed to decode content type for " + name);
                }
                this.contents.put(name, new IMCSObject(this, name, null, p.getBytes()));
                continue;
            }
            if (!p.getName().startsWith("co/")) continue;
            name = p.getName().substring(p.getName().indexOf(47) + 1);
            logger.info("  loading " + name);
            if (!cts.containsKey(name)) {
                logger.error("no content type for " + name);
                continue;
            }
            this.contents.put(name, new IMCSObject(this, name, (String)cts.get(name), p.getBytes()));
        }
    }

    public String publicUrl(String key) {
        return this.baseUri + key;
    }

    public String publicWriteTo(String key) {
        return this.baseUri + key;
    }
}

