/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.zinutils.sync.LockingCounter;

public class CountingExecutor
implements Executor {
    private final LockingCounter counter;
    private final ExecutorService svc;

    public CountingExecutor(LockingCounter counter, ExecutorService svc) {
        this.counter = counter;
        this.svc = svc;
    }

    @Override
    public void execute(Runnable command) {
        this.counter.lock("executor");
        this.svc.execute(() -> {
            try {
                command.run();
            }
            finally {
                this.counter.release("executor");
            }
        });
    }
}

