/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.decoration;

import java.io.IOException;
import org.dmfs.httpessentials.HttpMethod;
import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.client.HttpRequestEntity;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseHandler;
import org.dmfs.httpessentials.decoration.Decoration;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.headers.Headers;

public final class HeaderDecorated<T>
implements HttpRequest<T> {
    private final HttpRequest<T> mOriginalRequest;
    private final Decoration<Headers> mHeadersDecoration;

    public HeaderDecorated(HttpRequest<T> originalRequest, Decoration<Headers> headersDecoration) {
        this.mOriginalRequest = originalRequest;
        this.mHeadersDecoration = headersDecoration;
    }

    public HttpMethod method() {
        return this.mOriginalRequest.method();
    }

    public Headers headers() {
        return this.mHeadersDecoration.decorated(this.mOriginalRequest.headers());
    }

    public HttpRequestEntity requestEntity() {
        return this.mOriginalRequest.requestEntity();
    }

    public HttpResponseHandler<T> responseHandler(HttpResponse response) throws IOException, ProtocolError, ProtocolException {
        return this.mOriginalRequest.responseHandler(response);
    }
}

