/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.decoration;

import java.io.IOException;
import org.dmfs.httpessentials.HttpMethod;
import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.client.HttpRequestEntity;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseHandler;
import org.dmfs.httpessentials.decoration.Decoration;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.headers.Headers;

public final class EntityDecorated<T>
implements HttpRequest<T> {
    private final HttpRequest<T> mOriginalRequest;
    private final Decoration<HttpRequestEntity> mRequestEntityDecoration;

    public EntityDecorated(HttpRequest<T> originalRequest, Decoration<HttpRequestEntity> requestEntityDecoration) {
        this.mOriginalRequest = originalRequest;
        this.mRequestEntityDecoration = requestEntityDecoration;
    }

    public HttpMethod method() {
        return this.mOriginalRequest.method();
    }

    public Headers headers() {
        return this.mOriginalRequest.headers();
    }

    public HttpRequestEntity requestEntity() {
        return this.mRequestEntityDecoration.decorated(this.mOriginalRequest.requestEntity());
    }

    public HttpResponseHandler<T> responseHandler(HttpResponse response) throws IOException, ProtocolError, ProtocolException {
        return this.mOriginalRequest.responseHandler(response);
    }
}

