/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.FinalLogicSet;
import org.ziniki.cbtxstore.gls.GLRelationAction;
import org.ziniki.cbtxstore.gls.GLSInvokeSet;
import org.ziniki.cbtxstore.gls.GLSRelation;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.cbtxstore.gls.InvocationStatus;
import org.ziniki.cbtxstore.gls.Logic;
import org.ziniki.cbtxstore.gls.RelationFailedException;
import org.ziniki.cbtxstore.gls.SetRelationAction;
import org.ziniki.cbtxstore.gls.SlotBindings;
import org.ziniki.tdastore.NotifySubscriber;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.RelationAction;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.support.InvokeSet;
import org.ziniki.tdastore.support.ThreadAwareUOW;
import org.ziniki.tdastore.support.UOWExecutor;
import org.zinutils.exceptions.InvalidUsageException;

public class RelationExecutor {
    public final Logger logger = LoggerFactory.getLogger((String)"GLS");
    private final TDAStorage storage;
    private final UOWExecutor uowexec;
    private final GLUnitOfWork uow;
    private final GLSRelation r;
    private final List<GLRelationAction> gla;
    private final List<SetRelationAction> set;
    private final FinalLogicSet finalLogic;
    private final SlotBindings bindings;
    private final Set<GLRelationAction> fired = new HashSet<GLRelationAction>();

    public RelationExecutor(TDAStorage storage, Executor exec, UOWExecutor uowexec, UnitOfWork uow, GLSRelation r, List<GLRelationAction> glactions, List<SetRelationAction> setactions, FinalLogicSet finalLogic) {
        this.storage = storage;
        this.uowexec = uowexec;
        this.uow = (GLUnitOfWork)uow;
        this.r = r;
        this.bindings = new SlotBindings(storage, uow);
        this.bindings.walk(r);
        this.gla = new ArrayList<GLRelationAction>(glactions);
        this.set = new ArrayList<SetRelationAction>(setactions);
        this.finalLogic = finalLogic;
    }

    public synchronized boolean playGL(RelationAction toRemove) throws GLSException {
        boolean allDone = true;
        boolean somethingHappened = true;
        boolean onlyLogic = true;
        while (somethingHappened) {
            onlyLogic = true;
            somethingHappened = false;
            Iterator<GLRelationAction> it = this.gla.iterator();
            while (it.hasNext()) {
                GLRelationAction act = it.next();
                if (act == toRemove) {
                    it.remove();
                    this.logger.debug(this + ": Removed " + toRemove + " length = " + this.gla.size());
                    continue;
                }
                this.logger.debug(this + ": Action " + act + " is going to need processing");
                if (this.fired.contains(act)) {
                    this.logger.debug("Already fired " + act);
                    allDone = false;
                    onlyLogic = false;
                    continue;
                }
                if (act.isReady(this.bindings)) {
                    this.logger.info(this + ": Firing " + act);
                    InvocationStatus stat = act.invoke(this.storage, this.uowexec, this.uow, null, this.bindings);
                    if (stat == InvocationStatus.COMPLETED) {
                        this.logger.debug(this + ": Fired " + act + " and removed");
                        it.remove();
                        somethingHappened = true;
                    } else if (stat == InvocationStatus.FIRED) {
                        this.logger.debug(this + ": Fired " + act + " and added to pending");
                        this.fired.add(act);
                        allDone = false;
                        somethingHappened = true;
                    }
                    onlyLogic = false;
                    continue;
                }
                if (!(act instanceof Logic)) {
                    allDone = false;
                    onlyLogic = false;
                    continue;
                }
                allDone = false;
            }
        }
        this.logger.debug(this + ": at end of loop, allDone = " + allDone + " onlyLogic = " + onlyLogic + " fired = " + this.fired);
        if (!allDone && onlyLogic) {
            TreeSet<String> pending = new TreeSet<String>();
            for (GLRelationAction act : this.gla) {
                Logic l = (Logic)act;
                l.addPending(pending, this.r.backgroundVars, this.bindings);
            }
            pending.removeAll(this.r.backgroundVars);
            if (!pending.isEmpty()) {
                throw new GLSException(this + ": Logic waiting for variables that will never appear: " + pending);
            }
        }
        return allDone;
    }

    public void performFinalActions(UOWExecutor exec, GLUnitOfWork uow, RelationFailedException fatalError) {
        this.logger.info("preparing to perform final actions");
        this.finalLogic.performActions(exec, uow, this.bindings, fatalError);
        this.logger.info("finished performing final actions");
    }

    public synchronized void add(RelationAction act) {
        if (this.uow.hasDoneGL()) {
            throw new RuntimeException("Cannot add to relations once the UOW has completed");
        }
        if (act instanceof GLRelationAction) {
            this.gla.add((GLRelationAction)act);
        } else {
            this.set.add((SetRelationAction)act);
        }
        this.logger.info("gla for " + this.r + " now " + this.gla);
        this.needPlay();
    }

    private void needPlay() {
        this.uowexec.execute((ThreadAwareUOW)this.uow, false, () -> this.uow.playAll(null));
    }

    public boolean has(String slot) {
        return this.bindings.has(slot);
    }

    public Object bound(String slot) {
        if (!this.bindings.has(slot)) {
            throw new RuntimeException("There is no entry for " + slot + " in " + this.bindings);
        }
        return this.bindings.bound(slot);
    }

    public synchronized String outstanding() {
        return this.gla.toString() + this.bindings;
    }

    public synchronized String toString() {
        try {
            return "RelationExecutor{" + this.r + "}" + this.gla;
        }
        catch (Exception ex) {
            return "RelationExecutor[??]";
        }
    }

    public synchronized void gather(List<InvokeSet> allSets) {
        for (SetRelationAction i : this.set) {
            allSets.add(new GLSInvokeSet(this.r, this.bindings, i));
        }
    }

    public <T> T obtain(Class<T> clz, String var) {
        if (!this.bindings.has(var)) {
            throw new InvalidUsageException("there is no bound var " + var + " to obtain from " + this.bindings.keys());
        }
        Object bound = this.bindings.bound(var);
        if (bound == null) {
            return null;
        }
        if (!clz.isInstance(bound)) {
            throw new ClassCastException("cannot obtain " + var + " as " + clz + " because it is a " + bound.getClass());
        }
        return clz.cast(bound);
    }

    public void sendNotifications(String key, NotifySubscriber notifySubscriber) {
        this.storage.notifySubscribers((UnitOfWork)this.uow, key, notifySubscriber);
    }

    public void fatalError(Throwable ex) {
        this.uow.fatalError(ex);
    }
}

