/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.flasck.jvm.container.FLEnvironment;
import org.flasck.jvm.fl.FLCommonEvalContext;
import org.ziniki.cbtxstore.gls.CountDownExecutor;
import org.ziniki.cbtxstore.gls.FinalLogicSet;
import org.ziniki.cbtxstore.gls.GLRelationAction;
import org.ziniki.cbtxstore.gls.GLSRelation;
import org.ziniki.cbtxstore.gls.NotifyTestGLDone;
import org.ziniki.cbtxstore.gls.RelationExecutor;
import org.ziniki.cbtxstore.gls.RelationFailedException;
import org.ziniki.cbtxstore.gls.SetRelationAction;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.cbtxstore.gls.UOWState;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationAction;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.lowlevel.ExistingRecord;
import org.ziniki.tdastore.support.InvokeSet;
import org.ziniki.tdastore.support.ThreadAwareTxManager;
import org.ziniki.tdastore.support.ThreadAwareUOW;
import org.ziniki.tdastore.support.UOWExecutor;
import org.zinutils.exceptions.InvalidUsageException;

public abstract class GLUnitOfWork
extends FLCommonEvalContext
implements ThreadAwareUOW {
    private static final int UOW_TIMEOUT;
    protected UOWState state;
    private NotifyTestGLDone notifyTestDone;

    public GLUnitOfWork(FLEnvironment env, String id, ThreadAwareTxManager txmgr, TDAStorage storage, Executor exec, UOWExecutor uowexec) {
        super(env);
        this.state = new UOWState(id, txmgr, storage, exec, uowexec, new FinalLogicSet(null));
    }

    public GLUnitOfWork(GLUnitOfWork from) {
        super(from.env);
        this.state = from.state;
    }

    public String id() {
        return this.state.id;
    }

    public ThreadAwareTxManager getManager() {
        return this.state.txmgr;
    }

    public void setWaitTime(int timeout, TimeUnit unit) {
        long from;
        long to;
        if (this.state.startAt == null) {
            this.state.startAt = new Date();
        }
        if ((to = (from = this.state.startAt.getTime()) + TimeUnit.MILLISECONDS.convert(timeout, unit)) - from > 60000L) {
            throw new InvalidUsageException("maximum UOW wait time is 60s");
        }
        this.state.completeBy = new Date(to);
        this.logger.info("Adjusting completeBy for " + this + " to " + this.state.completeBy);
    }

    public void whenCommitted(RelationHandler handler, String method) throws GLSException {
        this.state.endLogic.whenCommitted(handler, method);
    }

    public void whenRolledBack(RelationHandler handler, String method) throws GLSException {
        this.state.endLogic.whenRolledBack(handler, method);
    }

    public void atEnd(RelationHandler handler, String method) throws GLSException {
        this.state.endLogic.atEnd(handler, method);
    }

    public synchronized Relation relation(RelationHandler handler) {
        GLSRelation ret = new GLSRelation((UnitOfWork)this, handler, this.state.originals.size());
        if (!this.state.started) {
            this.state.originals.add(ret);
        } else {
            this.logger.debug("relation " + ret + " created while tx in progress; will need to call makeReady");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void makeReady(Relation r) {
        if (!this.state.started) {
            this.logger.info("MakeReady[" + r + "] called, but since UOW has not yet started, it should already have been added to originals on create");
            return;
        }
        GLSRelation cr = (GLSRelation)r;
        Map<Relation, RelationExecutor> map = this.state.relexecs;
        synchronized (map) {
            this.state.relexecs.put(cr, cr.makeReady(this.state.storage, this.state.exec, this.state.uowexec, (UnitOfWork)this));
            this.logger.debug("Make " + r + " ready; now have " + this.state.relexecs);
        }
        this.playAll(null);
    }

    public void enact() {
        if (this.state.started) {
            throw new InvalidUsageException("cannot enact UOW multiple times");
        }
        this.starttx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void starttx() {
        this.state.started = true;
        Map<Relation, RelationExecutor> map = this.state.relexecs;
        synchronized (map) {
            this.state.relexecs.clear();
            for (GLSRelation r : this.state.originals) {
                this.state.relexecs.put(r, r.makeReady(this.state.storage, this.state.exec, this.state.uowexec, (UnitOfWork)this));
            }
        }
        this.playAll(null);
    }

    public void manualLock() {
        this.state.manualLock.getAndIncrement();
    }

    public synchronized void manualRelease() {
        if (this.state.manualLock.decrementAndGet() == 0) {
            this.playAll(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void playAll(GLRelationAction action) {
        boolean allDone = this.state.manualLock.get() == 0;
        this.logger.debug("initially allDone = " + allDone);
        try {
            ArrayList<RelationExecutor> use;
            Map<Relation, RelationExecutor> map = this.state.relexecs;
            synchronized (map) {
                use = new ArrayList<RelationExecutor>(this.state.relexecs.values());
            }
            for (RelationExecutor re : use) {
                this.logger.debug("after " + re + ", allDone = " + (allDone &= re.playGL(action)));
            }
        }
        catch (GLSException ex) {
            this.fatalError(ex);
        }
        this.logger.debug("In playAll, allDone = " + allDone + " and doneReads = " + this.state.doneReads);
        if (allDone && !this.state.doneReads) {
            this.gldone();
        }
    }

    public boolean has(String id) {
        return this.state.retrs.containsKey(id);
    }

    public <T> ExistingRecord getCB(String id) {
        ExistingRecord retr = this.state.retrs.get(id);
        if (retr == null) {
            throw new NullPointerException("Doc " + id + " was apparently not retrieved");
        }
        return retr;
    }

    public <T> void remember(String id, ExistingRecord retr) {
        this.logger.info("Remembering " + id + " in the UOW");
        this.state.retrs.put(id, retr);
    }

    public void duplicateRetry(String id) {
        this.state.needRetry = true;
    }

    public void changedRetry() {
        this.state.needRetry = true;
    }

    public void duplicateFailed(String id) {
        if (this.state.fatalError == null) {
            this.state.fatalError = new RelationFailedException();
        }
        this.state.fatalError.add(new RuntimeException("attempt to create duplicate " + id));
    }

    public void fatalError(Throwable ex) {
        if (this.state.fatalError == null) {
            this.state.fatalError = new RelationFailedException();
        }
        this.state.fatalError.add(ex);
    }

    public synchronized void gldone() {
        this.logger.debug("gldone called with doneReads = " + this.state.doneReads);
        if (this.state.doneReads) {
            throw new RuntimeException("You should not call setters in a UOW more than once");
        }
        this.state.doneReads = true;
        ArrayList<InvokeSet> allSets = new ArrayList<InvokeSet>();
        for (RelationExecutor exec : this.state.relexecs.values()) {
            exec.gather(allSets);
        }
        this.state.setterRunner = this.state.txmgr.runSetActions(this.state.storage, this.state.uowexec, (UnitOfWork)this, allSets);
    }

    public synchronized void txdone() {
        if (this.state.hasCompleted) {
            throw new RuntimeException("You should not complete a UOW more than once");
        }
        this.logger.info("UOW " + this.state.id + " completing with " + this.state.relexecs + " and txcompleted = " + this.state.txCompleted);
        if (this.state.fatalError == null && this.state.needRetry) {
            this.reset();
            this.starttx();
            return;
        }
        this.state.hasCompleted = true;
        this.logger.info("UOW " + this.state.id + " completed; txCompleted = " + this.state.txCompleted);
        CountDownExecutor cde = new CountDownExecutor(this.state.uowexec);
        if (this.state.fatalError != null) {
            for (RelationExecutor r : this.state.relexecs.values()) {
                r.performFinalActions(cde, this, this.state.fatalError);
            }
            this.state.endLogic.performActions(cde, this, null, this.state.fatalError);
        } else {
            for (RelationExecutor r : this.state.relexecs.values()) {
                r.performFinalActions(cde, this, null);
            }
            this.state.endLogic.performActions(cde, this, null, null);
        }
        cde.notifyOnDone(this);
        if (this.notifyTestDone != null) {
            this.notifyTestDone.has(this.state.fatalError);
        }
    }

    private void reset() {
        this.state.fatalError = null;
        this.state.needRetry = false;
        this.state.doneReads = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block() {
        if (this.state.started) {
            throw new RuntimeException("Cannot block uow once enacted");
        }
        try {
            this.logger.info("blocking for UOW " + this);
            this.enact();
            this.doWaiting(this.state.txCompleted);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.logger.error("timed out", (Throwable)e);
            for (Map.Entry<Relation, RelationExecutor> re : this.state.relexecs.entrySet()) {
                this.logger.error("  died when re for " + re.getKey() + " had " + re.getValue().outstanding());
            }
            this.fatalError(e);
        }
        finally {
            this.logger.info("reverting to UOW " + this.state.previous);
            this.state.txmgr.currentThreadUOW(this.state.previous);
        }
    }

    protected void waitForEnd() {
        try {
            this.logger.info("waiting for end of UOW " + this);
            this.doWaiting(this.state.txCompleted);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.logger.error("timed out", (Throwable)e);
            this.fatalError(e);
        }
    }

    private void doWaiting(CompletableFuture<TxError> waitFor) throws InterruptedException, ExecutionException, TimeoutException {
        this.strategyHelper();
        if (this.state.startAt == null) {
            this.state.startAt = new Date();
        }
        if (this.state.completeBy == null) {
            this.state.completeBy = new Date(this.state.startAt.getTime() + (long)UOW_TIMEOUT);
        }
        this.logger.info("waiting for UOW " + this + " with " + waitFor + " until " + this.state.completeBy);
        while (true) {
            long waitMS;
            if ((waitMS = this.state.completeBy.getTime() - new Date().getTime()) <= 0L) {
                waitMS = 1L;
            }
            try {
                TxError err = waitFor.get(waitMS, TimeUnit.MILLISECONDS);
                if (err != null) {
                    this.logger.error("tx marked complete with error " + err);
                } else {
                    this.logger.info("tx marked complete without error");
                }
                return;
            }
            catch (TimeoutException ex) {
                if (new Date().compareTo(this.state.completeBy) == -1) continue;
                throw ex;
            }
            break;
        }
    }

    protected void strategyHelper() {
    }

    public synchronized void opDone(RelationAction ra) {
        if (ra instanceof GLRelationAction) {
            this.logger.debug(ra + " has completed; playing all");
            GLRelationAction action = (GLRelationAction)ra;
            this.playAll(action);
        } else {
            this.logger.debug(ra + " has completed; waiting for sets to complete");
            SetRelationAction action = (SetRelationAction)ra;
            this.state.setterRunner.waitForSets((RelationAction)action);
        }
    }

    public synchronized Object read(Relation r, String slot) {
        RelationExecutor re = this.state.relexecs.get(r);
        return re.bound(slot);
    }

    public boolean hasCompleted() {
        return this.state.hasCompleted;
    }

    public boolean hasDoneGL() {
        return this.state.doneReads;
    }

    public void waitForResult() {
        if (!this.hasCompleted()) {
            this.waitForEnd();
        }
    }

    public boolean hadError() {
        return this.state.fatalError != null && this.state.fatalError.any();
    }

    public Throwable getError() {
        if (this.hadError()) {
            return this.state.fatalError.getFirst();
        }
        return super.getError();
    }

    public <T> void trait(Class<T> clz, T value) {
        this.state.traits.put(clz, value);
    }

    public <T> T trait(Class<T> clz) {
        return clz.cast(this.state.traits.get(clz));
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.state.id + "]";
    }

    public void notifyTest(NotifyTestGLDone done) {
        this.notifyTestDone = done;
    }

    static {
        String tostr = System.getenv("ZINIKI_UOW_TIMEOUT");
        if (tostr == null) {
            tostr = System.getProperty("ziniki.uow.timeout");
        }
        UOW_TIMEOUT = tostr != null ? Integer.parseInt(tostr) : 5000;
    }
}

