/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.cbtxstore.gls.Logic;
import org.ziniki.cbtxstore.gls.LogicAnalyzer;
import org.ziniki.cbtxstore.gls.SlotBindings;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.support.UOWExecutor;

public class FinalLogicSet {
    public final Logger logger = LoggerFactory.getLogger((String)"GLS");
    private final RelationHandler commonHandler;
    private final List<Logic> committedLogics = new ArrayList<Logic>();
    private final List<Logic> rollbackLogics = new ArrayList<Logic>();

    public FinalLogicSet(RelationHandler handler) {
        this.commonHandler = handler;
    }

    public void whenCommitted(String method) throws GLSException {
        this.whenCommitted(this.commonHandler, method);
    }

    public void whenRolledBack(String method) throws GLSException {
        this.whenRolledBack(this.commonHandler, method);
    }

    public void atEnd(String method) throws GLSException {
        this.atEnd(this.commonHandler, method);
    }

    public void whenCommitted(RelationHandler handler, String method) throws GLSException {
        Logic l = LogicAnalyzer.analyzeMethod(handler, method, true);
        this.committedLogics.add(l);
    }

    public void whenRolledBack(RelationHandler handler, String method) throws GLSException {
        Logic l = LogicAnalyzer.analyzeMethod(handler, method, true);
        this.rollbackLogics.add(l);
    }

    public void atEnd(RelationHandler handler, String method) throws GLSException {
        Logic l = LogicAnalyzer.analyzeMethod(handler, method, true);
        this.committedLogics.add(l);
        this.rollbackLogics.add(l);
    }

    public void performActions(UOWExecutor exec, GLUnitOfWork uow, SlotBindings bindings, TxError error) {
        this.logger.debug("Firing " + this.committedLogics + " or " + this.rollbackLogics + " on complete with error = " + error);
        if (bindings == null) {
            bindings = new SlotBindings(null, (UnitOfWork)uow);
        }
        bindings.bind(TxError.class.getName(), error);
        if (error == null) {
            for (Logic l : this.committedLogics) {
                this.logger.info("Firing " + l + " on commit");
                l.invoke(null, exec, uow, null, bindings);
            }
        } else {
            for (Logic l : this.rollbackLogics) {
                this.logger.info("Firing " + l + " on rollback");
                l.invoke(null, exec, uow, null, bindings);
            }
        }
    }
}

